% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioM2.R
\name{VisMulti}
\alias{VisMulti}
\title{Visualization of the results of functions in the BioM2 package}
\usage{
VisMulti(
  BioM2_pathways_obj = NULL,
  FindParaModule_obj = NULL,
  ShowModule_obj = NULL,
  PathwaysModule_obj = NULL,
  exact = TRUE,
  n_neighbors = 8,
  min_dist = 2,
  size = 5,
  target_weight = 0.5,
  width = 13,
  height = 10
)
}
\arguments{
\item{BioM2_pathways_obj}{Results produced by BioM2(,target='pathways')}

\item{FindParaModule_obj}{Results produced by FindParaModule()}

\item{ShowModule_obj}{Results produced by ShowModule()}

\item{PathwaysModule_obj}{Results produced by PathwaysModule()}

\item{exact}{Whether to divide GO pathways more accurately}

\item{n_neighbors}{The size of local neighborhood (in terms of number of neighboring sample points) used for manifold approximation.
Larger values result in more global views of the manifold, while smaller values result in more local data being preserved.
In general values should be in the range 2 to 100.}

\item{min_dist}{The effective minimum distance between embedded points.
Smaller values will result in a more clustered/clumped embedding where nearby points on the manifold are drawn closer together,
while larger values will result on a more even dispersal of points.
The value should be set relative to the spread value,
which determines the scale at which embedded points will be spread out.}

\item{size}{Scatter plot point size}

\item{target_weight}{Weighting factor between data topology and target topology.
A value of 0.0 weights entirely on data, a value of 1.0 weights entirely on target.
The default of 0.5 balances the weighting equally between data and target.
Only applies if y is non-NULL.}

\item{width}{image width}

\item{height}{image height}
}
\value{
a pdf file
}
\description{
Visualization of the results of functions in the BioM2 package
}
