% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document_dataset_MRMC.R
\docType{data}
\name{dddddd}
\alias{dddddd}
\title{Multiple reader and one modality data}
\description{
This is a subset of \code{ \link{dd}}

\strong{  This dataset is made, as a toy data,   } \emph{ which is a subset of data \code{dd} }
\describe{
\item{ dddddd$M   }{  2 modalities   }
\item{ dddddd$C   }{  3 Confidence levels }
\item{ dddddd$Q   }{  2 readers}
}
}
\details{
The model did not converge both null model and alternative model in 2019 Jun 21.




\strong{Contents of dddddd}


 \code{NL}  = 142 (Number of Lesions)

 \code{NI} = 199 (Number of Images)#'





\strong{\emph{ Contents:  }}

 \emph{          Multiple readers and multiple modalities case, i.e., MRMC case   }




---------------------------------------------------------------------------------------------------
\tabular{ccccc}{
 \strong{ModalityID } \tab   \strong{ReaderID }  \tab  \strong{ Confidence levels} \tab   \strong{No. of false alarms} \tab   \strong{No. of hits}.\cr
  \code{q} \tab  \code{ m}  \tab   \code{c} \tab  \code{ f} \tab \code{ h}\cr
  -------------- \tab ------------- \tab ------------------------ \tab  ------------------- \tab ----------------\cr
1\tab 1\tab 3\tab 20\tab 11\cr
1\tab 1\tab 2\tab 29\tab 5\cr
1\tab 1\tab 1\tab 21\tab 1\cr
1\tab 2\tab 3\tab  6\tab 29\cr
1\tab 2\tab 2\tab 15\tab 1\cr
1\tab 2\tab 1\tab 22\tab 0\cr
2\tab 1\tab 3\tab 21\tab 13\cr
2\tab 1\tab 2\tab 24\tab 4\cr
2\tab 1\tab 1\tab 23\tab 1\cr
2\tab 2\tab 3\tab  5\tab 29\cr
2\tab 2\tab 2\tab 30\tab 1\cr
2\tab 2\tab 1\tab 40\tab 0\cr
}
---------------------------------------------------------------------------------------------------
}
\examples{


#----------------------------------------------------------------------------------------
#                        Show data by table
#----------------------------------------------------------------------------------------



                        viewdata(dddddd)




####1#### ####2#### ####3#### ####4#### ####5#### ####6#### ####7#### ####8#### ####9####
#----------------------------------------------------------------------------------------
#                       make an object dddd from an object dd
#----------------------------------------------------------------------------------------



ddd  <-  data.frame(m=dd$m,q=dd$q,c=dd$c,h=dd$h,f=dd$f)
dddd <- ddd[ddd$q < 3,]

# The following code extract the first and the second modality from dd
dddd <- dddd[dddd$m < 3,]  #  Reduce the dataset ddd, i.e., dd
dddd <- dddd[dddd$c <4,]
ddd <- list(
  m=dddd$m,
  q=dddd$q,
  c=dddd$c,
  h=dddd$h,
  f=dddd$f,
  NL=142,
  C=max(dddd$c),
  M=max(dddd$m),
  Q=max(dddd$q)
)

dddddd <-ddd


# This dataset is made in 2019 July 6, for the aim of easy exihibition
# This dataset is very minimum, and it is easy to view


\donttest{
#-------------------------------------------------------------------------------
#                       Fit a model to data dddddd
#-------------------------------------------------------------------------------

fit <- fit_Bayesian_FROC( ite  = 1111,
                           cha = 1,
                            summary = F,
                              Null.Hypothesis = F,
                               dataList = dddddd )


#-------------------------------------------------------------------------------
#           Draw a curves and data points to confirm goodness of fit
#-------------------------------------------------------------------------------

             DrawCurves(fit,
                       modalityID = c(1,2),
                       readerID = c(1,2)
                       )


#-------------------------------------------------------------------------------
#   When I saw the plots, the author became happy, because it was well fitted
#-------------------------------------------------------------------------------



# Good Bye, pretty crowd!   2019 July 6
# I always think who read this? My heart empty and empty.

}

}
\references{
Example data of Jafroc software
}
\seealso{
\code{\link{dataList.Chakra.Web} }
 \code{\link{dataList.Chakra.Web.orderd} }
  \code{\link{dd} }
}
\author{
Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
}
