% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document_dataset_MRMC.R
\docType{data}
\name{data_2modaities_2readers_3confidence}
\alias{data_2modaities_2readers_3confidence}
\title{data: 2 readers, 2 modalities and 3 confideneces}
\description{
small data example in the FROC context
}
\details{
\describe{
\item{ the number of modalities, denoted by \code{M}   }{  2 modalities  }
\item{ the number of Confidences, denoted by \code{C}   }{  3 Confidence levels }
\item{ the number of readers, denoted by \code{Q}  }{  2 readers}
}



\strong{Contents }


 \code{NL}  = 142 (Number of Lesions)

 \code{NI} = 57 (Number of Images)#'





\strong{\emph{ Contents:  }}

 \emph{          Multiple readers and multiple modalities case, i.e., MRMC case   }

\tabular{ccccc}{
 \strong{ModalityID } \tab   \strong{ReaderID }  \tab  \strong{ Confidence levels} \tab   \strong{No. of false alarms} \tab   \strong{No. of hits}.\cr
  \code{m} \tab  \code{ q}  \tab   \code{c} \tab  \code{ f} \tab \code{ h}\cr
   -------------- \tab ------------- \tab ------------------------ \tab  ------------------- \tab ----------------\cr
  1 \tab 1 \tab 3 \tab 20 \tab 111\cr
  1 \tab 1 \tab 2 \tab 29 \tab  55\cr
  1 \tab 1 \tab 1 \tab 21 \tab  22\cr
  1 \tab 2 \tab 3 \tab  6 \tab 100\cr
  1 \tab 2 \tab 2 \tab 15 \tab  44\cr
  1 \tab 2 \tab 1 \tab 22 \tab  11\cr
  2 \tab 1 \tab 3 \tab  6 \tab  66\cr
  2 \tab 1 \tab 2 \tab 24 \tab  55\cr
  2 \tab 1 \tab 1 \tab 23 \tab   1\cr
  2 \tab 2 \tab 3 \tab  5 \tab  66\cr
  2 \tab 2 \tab 2 \tab 30 \tab  55\cr
  2 \tab 2 \tab 1 \tab 40 \tab  44\cr
}
}
\examples{


#----------------------------------------------------------------------------------------
#                        Show data by table
#----------------------------------------------------------------------------------------



                        viewdata(data_of_36_readers_and_a_single_modality)


plot_FPF_and_TPF_from_a_dataset(data_of_36_readers_and_a_single_modality)

####1#### ####2#### ####3#### ####4#### ####5#### ####6#### ####7#### ####8#### ####9####
#----------------------------------------------------------------------------------------
#                       make this data from functions in this package
#----------------------------------------------------------------------------------------



v  <- v_truth_creator_for_many_readers_MRMC_data(M=1,Q=36)
m  <- mu_truth_creator_for_many_readers_MRMC_data(M=1,Q=36)
d  <- create_dataList_MRMC(mu.truth = m,v.truth = v)


# The last object named d is the desired dataset.

\donttest{
 fit_Bayesian_FROC(data_2modaities_2readers_3confidence,ite = 1111)
}

}
\references{
Example data of Jafroc software
}
\seealso{
Not \code{\link{dataList.Chakra.Web} }
But \code{\link{dataList.Chakra.Web.orderd} }
 Not \code{\link{dd} }
}
\author{
Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
}
