% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multMixNRMI.R
\name{cpo.multNRMI}
\alias{cpo.multNRMI}
\title{Extract the Conditional Predictive Ordinates (CPOs) from a list of fitted objects}
\usage{
\method{cpo}{multNRMI}(object, ...)
}
\arguments{
\item{object}{A fit obtained through from the functions MixNRMI1/MixNRMI1cens}

\item{...}{Further arguments to be passed to generic function, ignored at the moment}
}
\value{
A vector of Conditional Predictive Ordinates (CPOs)
}
\description{
This function assumes that all chains have the same size. To allow for different chain sizes, care should be paid to proper weighting.
}
\examples{
data(acidity)
out <- multMixNRMI1(acidity, parallel = TRUE, Nit = 10, ncores = 2)
cpo(out)
}
