% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/azureml-package.R
\docType{package}
\name{AzureML-package}
\alias{AzureML}
\alias{AzureML-package}
\title{Interface to Azure ML Studio datasets and experiments.}
\description{
Allows you to work with Azure ML Studio datasets and experiments directly from R.
}
\section{Summary of functions}{


1. Create a reference to an Azure ML workspace

\itemize{
\item Workspace: \code{\link{workspace}}
}

2. Datasets

\itemize{
   \item List available datasets: \code{\link{datasets}}
   \item Download datasets: \code{\link{download.datasets}}
   \item Upload a dataset: \code{\link{upload.dataset}}
   \item Delete datasets: \code{\link{delete.datasets}}
}

3. Experiments

\itemize{
   \item Get experiments: \code{\link{experiments}}
   \item Get data from an experiment port: \code{\link{download.intermediate.dataset}}
}

4. Web Services

\itemize{
   \item List available services: \code{\link{services}}
   \item Consume a web service (run data through it and retrieve result): \code{\link{consume}}
   \item Publish an R function as a web service: \code{\link{publishWebService}}
   \item Update an existing web service: \code{\link{updateWebService}}
   \item List web service endpoints: \code{\link{endpoints}}
}

5. Configure a settings file with your AzureML secrets

The \code{\link{workspace}} function optionally reads your AzureML credentials from a settings file located at \code{~/.azureml/settings.json}. You can read and write this file using:

\itemize{
   \item Write: \code{\link{write.AzureML.config}}
   \item Read: \code{\link{read.AzureML.config}}
}
}
\keyword{package}

