% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/summary.R
\docType{methods}
\name{summary}
\alias{summary}
\alias{summary,MCMC-method}
\alias{summary,PhasesMCMC-method}
\title{Marginal Summary Statistics for Multiple MCMC Chains}
\usage{
\S4method{summary}{MCMC}(object, level = 0.95, calendar = getOption("ArchaeoPhases.calendar"))

\S4method{summary}{PhasesMCMC}(object, level = 0.95, calendar = getOption("ArchaeoPhases.calendar"))
}
\arguments{
\item{object}{An \code{\linkS4class{MCMC}} or a \code{\linkS4class{PhasesMCMC}} object.}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.}

\item{calendar}{A \code{\linkS4class{TimeScale}} object specifying the target calendar
(see \code{\link[=calendar]{calendar()}}).}
}
\value{
A \code{\link{data.frame}} where the rows correspond to the chains of interest and
columns to the following statistics:
\describe{
\item{mean}{The mean of the MCMC chain.}
\item{sd}{The standard deviation of the MCMC chain.}
\item{min}{Minimum value of the MCMC chain.}
\item{q1}{First quantile of the MCMC chain.}
\item{median}{Median of the MCMC chain.}
\item{q3}{Third quantile of the MCMC chain.}
\item{max}{Maximum value of the MCMC chain.}
\item{lower}{Lower boundary of the \link[=interval_credible]{credible interval}
of the MCMC chain at \code{level}.}
\item{upper}{Upper boundary of the \link[=interval_credible]{credible interval}
of the MCMC chain at \code{level}.}
}
}
\description{
Calculates summary statistics of the output of the MCMC algorithm for
multiple parameters. Results are given in calendar years (BC/AD).
}
\examples{
## Coerce to MCMC
eve <- as_events(mcmc_events, calendar = CE(), iteration = 1)

## Summary
summary(eve, calendar = CE())
summary(eve, calendar = BP())

## Plot events
plot(eve, calendar = CE(), interval = "credible", level = 0.68)
plot(eve, calendar = BP(), interval = "hdr", level = 0.68)
plot(eve[, 1], interval = "hdr")

## Compute phases
pha <- phases(eve, groups = list(B = c(2, 4), A = c(1, 3)))

## Summary
summary(pha, calendar = CE())
summary(pha, calendar = BP())

## Plot phases
plot(pha, calendar = BP())
plot(pha, succession = "hiatus")
plot(pha, succession = "transition")
}
\seealso{
Other statistics: 
\code{\link{interval_credible}()},
\code{\link{interval_hdr}()},
\code{\link{sensitivity}()}
}
\author{
A. Philippe, M.-A. Vibet, T. S. Dye, N. Frerebeau
}
\concept{statistics}
