% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing_impute.R
\name{impute_missing}
\alias{impute_missing}
\title{Missing Value Imputation}
\usage{
impute_missing(data, method = "mean", k = NULL)
}
\arguments{
\item{data}{Input data.}

\item{method}{Method of handling missing values: "mean," "median," "mode," "locf," or "knn."}

\item{k}{Value of the number of neighbors to be checked (only for knn method). Default is NULL.}
}
\value{
a data frame with imputed missing values
}
\description{
This function performs missing value imputation in the input data using various methods.
 The available imputation methods are:
  
 - "mean": Imputes missing values with the mean of the variable.
 - "median": Imputes missing values with the median of the variable.
 - "mode": Imputes missing values with the mode of the variable (for categorical data).
 - "locf": Imputes missing values using the Last Observation Carried Forward method.
 - "knn": Imputes missing values using the k-Nearest Neighbors algorithm (specify k).
}
\examples{
data(airquality)
impute_missing(airquality, method='mean')

}
