% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TukeyTest.R
\name{TukeyTest}
\alias{TukeyTest}
\title{Tukey HSD Test for Multiple Comparisons}
\usage{
TukeyTest(modelo, alpha = 0.05)
}
\arguments{
\item{modelo}{An object of class \code{aov} or \code{lm} representing an ANOVA model.}

\item{alpha}{Significance level (default is 0.05).}
}
\value{
An object of class \code{"tukey"} and \code{"comparaciones"}, containing:
\itemize{
  \item \code{Resultados}: A data frame of pairwise comparisons with mean differences, critical value, p-value, and significance level.
  \item \code{Promedios}: A named numeric vector of group means.
  \item \code{Orden_Medias}: A character vector with group names ordered from highest to lowest mean.
  \item \code{Metodo}: A character string indicating the method used ("Tukey").
}
}
\description{
Performs Tukey's Honest Significant Difference (HSD) test for all pairwise
comparisons after fitting an ANOVA model. This post hoc method uses the
studentized range distribution and is appropriate when variances are equal
across groups and observations are independent.
}
\details{
Tukey's test controls the family-wise error rate and is widely used when group
comparisons have not been planned in advance.

Advantages:
- Strong control of Type I error rate.
- Ideal for balanced designs with equal variances.

Disadvantages:
- Assumes equal variances and sample sizes.
- Less powerful with heteroscedasticity.
}
\examples{
data(d_e, package = "Analitica")
mod <- aov(Sueldo_actual ~ as.factor(labor), data = d_e)
resultado <- TukeyTest(mod)
summary(resultado)
plot(resultado)

}
\references{
Tukey, J. W. (1949). "Comparing individual means in the analysis of variance." \emph{Biometrics}, 5(2), 99–114. <https://doi.org/10.2307/3001913>
}
