% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get_est_param}
\alias{get_est_param}
\title{Transform parameters estimated in SAM class to parameters structure in MSD function}
\usage{
get_est_param(theta, model_name)
}
\arguments{
\item{theta}{estimated parameters through MLE}

\item{model_name}{fitted stochastic process, options from ('BM','OU','FBM','OU+FBM')}
}
\value{
A vector of estimated parameters after transformation with structure
\code{theta} in \code{\link{get_MSD}}.
}
\description{
Transform parameters estimated using Maximum Likelihood Estimation (MLE) in
\code{SAM} class, to parameters contained in MSD with structure \code{theta}
in \code{\link{get_MSD}}.
}
\references{
Gu, M., He, Y., Liu, X., & Luo, Y. (2023). Ab initio uncertainty
quantification in scattering analysis of microscopy.
arXiv preprint arXiv:2309.02468.

Gu, M., Luo, Y., He, Y., Helgeson, M. E., & Valentine, M. T. (2021).
Uncertainty quantification and estimation in differential dynamic microscopy.
Physical Review E, 104(3), 034610.
}
\author{
\packageAuthor{AIUQ}
}
\keyword{internal}
