% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perception.R
\name{vmperception}
\alias{vmperception}
\title{Perception Probabilities of Visual Meteor Magnitudes}
\usage{
vmperception(m, deriv.degree = 0L)
}
\arguments{
\item{m}{numerical; difference between the limiting magnitude and the meteor magnitude.}

\item{deriv.degree}{integer; degree of derivative of the perception probability.
Currently, valid values of \code{deriv.degree} are \code{0}, \code{1} and \code{2}.}
}
\value{
This function returns the visual perception probabilities.
If \code{deriv.degree} is specified, it will return the \code{deriv.degree}-th order derivative
of the perception probability.
}
\description{
Provides the perception probability of visual meteor magnitudes and its first derivative.
}
\details{
The perception probabilities of \emph{Koschack R., Rendtel J., 1990b}
are estimated with the formula
\deqn{
    p(m) = \begin{cases}
        1.0 - \exp\left(-z(m + 0.5)\right)\  & \text{ if } m > -0.5,\\
        0.0 \  & \text{ otherwise,}
    \end{cases}
}
where
\deqn{
z(x) = 0.003 \, x + 0.0056 \, x^2 + 0.0014 \, x^4
}
and \code{m} is the difference between the limiting magnitude and the meteor magnitude.
}
\examples{
# Perception probability of visually estimated meteor of magnitude 3.0
# with a limiting magnitude of 5.6.
vmperception(5.6 - 3.0)

# plot
old_par <- par(mfrow = c(1,1))
plot(
    vmperception,
    -0.5, 8,
    main = paste(
        'perception probability of',
        'visual meteor magnitudes'
    ),
    col = "blue",
    xlab = 'm',
    ylab = 'p'
)
plot(
    function(m) {
        vmperception(m, deriv.degree=1L)/vmperception(m)
    },
    -0.3, 8,
    main = paste(
        'q-values of',
        'visual meteor magnitudes'
    ),
    col = "blue",
    log = 'y',
    xlab = 'm',
    ylab = 'q'
)

par(old_par)
}
\references{
Koschack R., Rendtel J., 1990b \emph{Determination of spatial number density and mass index from visual meteor observations (II).} WGN 18, 119–140.
}
