% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/wrapers.R
\name{torch_nonzero}
\alias{torch_nonzero}
\title{Nonzero}
\usage{
torch_nonzero(self, as_list = FALSE)
}
\arguments{
\item{self}{(Tensor) the input tensor.}

\item{as_list}{If \code{FALSE}, the output tensor containing indices. If \code{TRUE}, one
1-D tensor for each dimension, containing the indices of each nonzero element
along that dimension.

\strong{When} \code{as_list} \strong{is \code{FALSE} (default)}:

Returns a tensor containing the indices of all non-zero elements of
\code{input}.  Each row in the result contains the indices of a non-zero
element in \code{input}. The result is sorted lexicographically, with
the last index changing the fastest (C-style).

If \code{input} has \eqn{n} dimensions, then the resulting indices tensor
\code{out} is of size \eqn{(z \times n)}, where \eqn{z} is the total number of
non-zero elements in the \code{input} tensor.

\strong{When} \code{as_list} \strong{is \code{TRUE}}:

Returns a tuple of 1-D tensors, one for each dimension in \code{input},
each containing the indices (in that dimension) of all non-zero elements of
\code{input} .

If \code{input} has \eqn{n} dimensions, then the resulting tuple contains \eqn{n}
tensors of size \eqn{z}, where \eqn{z} is the total number of
non-zero elements in the \code{input} tensor.

As a special case, when \code{input} has zero dimensions and a nonzero scalar
value, it is treated as a one-dimensional tensor with one element.}
}
\description{
Nonzero elements of tensors.
}
\examples{
if (torch_is_installed()) {

torch_nonzero(torch_tensor(c(1, 1, 1, 0, 1)))
}
}
