% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_gcd}
\alias{torch_gcd}
\title{Gcd}
\usage{
torch_gcd(self, other)
}
\arguments{
\item{self}{(Tensor) the input tensor.}

\item{other}{(Tensor) the second input tensor}
}
\description{
Gcd
}
\note{
This defines \eqn{gcd(0, 0) = 0}.
}
\section{gcd(input, other, *, out=None) -> Tensor }{


Computes the element-wise greatest common divisor (GCD) of \code{input} and \code{other}.

Both \code{input} and \code{other} must have integer types.
}

\examples{
if (torch_is_installed()) {

if (torch::cuda_is_available()) {
a <- torch_tensor(c(5, 10, 15), dtype = torch_long(), device = "cuda")
b <- torch_tensor(c(3, 4, 5), dtype = torch_long(), device = "cuda")
torch_gcd(a, b)
c <- torch_tensor(c(3L), device = "cuda")
torch_gcd(a, c)
}
}
}
