% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_bucketize}
\alias{torch_bucketize}
\title{Bucketize}
\usage{
torch_bucketize(self, boundaries, out_int32 = FALSE, right = FALSE)
}
\arguments{
\item{self}{(Tensor or Scalar) N-D tensor or a Scalar containing the search value(s).}

\item{boundaries}{(Tensor) 1-D tensor, must contain a monotonically increasing sequence.}

\item{out_int32}{(bool, optional) – indicate the output data type. \code{\link[=torch_int32]{torch_int32()}}
if True, \code{\link[=torch_int64]{torch_int64()}} otherwise. Default value is FALSE, i.e. default output
data type is \code{\link[=torch_int64]{torch_int64()}}.}

\item{right}{(bool, optional) – if False, return the first suitable location
that is found. If True, return the last such index. If no suitable index found,
return 0 for non-numerical value (eg. nan, inf) or the size of boundaries
(one pass the last index). In other words, if False, gets the lower bound index
for each value in input from boundaries. If True, gets the upper bound index
instead. Default value is False.}
}
\description{
Bucketize
}
\section{bucketize(input, boundaries, *, out_int32=FALSE, right=FALSE, out=None) -> Tensor }{


Returns the indices of the buckets to which each value in the \code{input} belongs, where the
boundaries of the buckets are set by \code{boundaries}. Return a new tensor with the same size
as \code{input}. If \code{right} is FALSE (default), then the left boundary is closed.
}

\examples{
if (torch_is_installed()) {

boundaries <- torch_tensor(c(1, 3, 5, 7, 9))
boundaries
v <- torch_tensor(rbind(c(3, 6, 9), c(3, 6, 9)))
v
torch_bucketize(v, boundaries)
torch_bucketize(v, boundaries, right=TRUE)
}
}
