% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-rnn.R
\name{nn_rnn}
\alias{nn_rnn}
\title{RNN module}
\usage{
nn_rnn(
  input_size,
  hidden_size,
  num_layers = 1,
  nonlinearity = NULL,
  bias = TRUE,
  batch_first = FALSE,
  dropout = 0,
  bidirectional = FALSE,
  ...
)
}
\arguments{
\item{input_size}{The number of expected features in the input \code{x}}

\item{hidden_size}{The number of features in the hidden state \code{h}}

\item{num_layers}{Number of recurrent layers. E.g., setting \code{num_layers=2}
would mean stacking two RNNs together to form a \verb{stacked RNN},
with the second RNN taking in outputs of the first RNN and
computing the final results. Default: 1}

\item{nonlinearity}{The non-linearity to use. Can be either \code{'tanh'} or
\code{'relu'}. Default: \code{'tanh'}}

\item{bias}{If \code{FALSE}, then the layer does not use bias weights \code{b_ih} and
\code{b_hh}. Default: \code{TRUE}}

\item{batch_first}{If \code{TRUE}, then the input and output tensors are provided
as \verb{(batch, seq, feature)}. Default: \code{FALSE}}

\item{dropout}{If non-zero, introduces a \code{Dropout} layer on the outputs of each
RNN layer except the last layer, with dropout probability equal to
\code{dropout}. Default: 0}

\item{bidirectional}{If \code{TRUE}, becomes a bidirectional RNN. Default: \code{FALSE}}

\item{...}{other arguments that can be passed to the super class.}
}
\description{
Applies a multi-layer Elman RNN with \eqn{\tanh} or \eqn{\mbox{ReLU}} non-linearity
to an input sequence.
}
\details{
For each element in the input sequence, each layer computes the following
function:

\deqn{
h_t = \tanh(W_{ih} x_t + b_{ih} + W_{hh} h_{(t-1)} + b_{hh})
}

where \eqn{h_t} is the hidden state at time \code{t}, \eqn{x_t} is
the input at time \code{t}, and \eqn{h_{(t-1)}} is the hidden state of the
previous layer at time \code{t-1} or the initial hidden state at time \code{0}.
If \code{nonlinearity} is \code{'relu'}, then \eqn{\mbox{ReLU}} is used instead of
\eqn{\tanh}.
}
\section{Inputs}{

\itemize{
\item \strong{input} of shape \verb{(seq_len, batch, input_size)}: tensor containing the features
of the input sequence. The input can also be a packed variable length
sequence.
\item \strong{h_0} of shape \verb{(num_layers * num_directions, batch, hidden_size)}: tensor
containing the initial hidden state for each element in the batch.
Defaults to zero if not provided. If the RNN is bidirectional,
num_directions should be 2, else it should be 1.
}
}

\section{Outputs}{

\itemize{
\item \strong{output} of shape \verb{(seq_len, batch, num_directions * hidden_size)}: tensor
containing the output features (\code{h_t}) from the last layer of the RNN,
for each \code{t}.  If a :class:\code{nn_packed_sequence} has
been given as the input, the output will also be a packed sequence.
For the unpacked case, the directions can be separated
using \code{output$view(seq_len, batch, num_directions, hidden_size)},
with forward and backward being direction \code{0} and \code{1} respectively.
Similarly, the directions can be separated in the packed case.
\item \strong{h_n} of shape \verb{(num_layers * num_directions, batch, hidden_size)}: tensor
containing the hidden state for \code{t = seq_len}.
Like \emph{output}, the layers can be separated using
\code{h_n$view(num_layers, num_directions, batch, hidden_size)}.
}
}

\section{Shape}{

\itemize{
\item Input1: \eqn{(L, N, H_{in})} tensor containing input features where
\eqn{H_{in}=\mbox{input\_size}} and \code{L} represents a sequence length.
\item Input2: \eqn{(S, N, H_{out})} tensor
containing the initial hidden state for each element in the batch.
\eqn{H_{out}=\mbox{hidden\_size}}
Defaults to zero if not provided. where \eqn{S=\mbox{num\_layers} * \mbox{num\_directions}}
If the RNN is bidirectional, num_directions should be 2, else it should be 1.
\item Output1: \eqn{(L, N, H_{all})} where \eqn{H_{all}=\mbox{num\_directions} * \mbox{hidden\_size}}
\item Output2: \eqn{(S, N, H_{out})} tensor containing the next hidden state
for each element in the batch
}
}

\section{Attributes}{

\itemize{
\item \code{weight_ih_l[k]}: the learnable input-hidden weights of the k-th layer,
of shape \verb{(hidden_size, input_size)} for \code{k = 0}. Otherwise, the shape is
\verb{(hidden_size, num_directions * hidden_size)}
\item \code{weight_hh_l[k]}: the learnable hidden-hidden weights of the k-th layer,
of shape \verb{(hidden_size, hidden_size)}
\item \code{bias_ih_l[k]}: the learnable input-hidden bias of the k-th layer,
of shape \code{(hidden_size)}
\item \code{bias_hh_l[k]}: the learnable hidden-hidden bias of the k-th layer,
of shape \code{(hidden_size)}
}
}

\section{Note}{


All the weights and biases are initialized from \eqn{\mathcal{U}(-\sqrt{k}, \sqrt{k})}
where \eqn{k = \frac{1}{\mbox{hidden\_size}}}
}

\examples{
if (torch_is_installed()) {
rnn <- nn_rnn(10, 20, 2)
input <- torch_randn(5, 3, 10)
h0 <- torch_randn(2, 3, 20)
rnn(input, h0)

}
}
