% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-activation.R
\name{nn_silu}
\alias{nn_silu}
\title{Applies the Sigmoid Linear Unit (SiLU) function, element-wise.
The SiLU function is also known as the swish function.}
\usage{
nn_silu(inplace = FALSE)
}
\arguments{
\item{inplace}{can optionally do the operation in-place. Default: \code{FALSE}}
}
\description{
Applies the Sigmoid Linear Unit (SiLU) function, element-wise.
The SiLU function is also known as the swish function.
}
\details{
See \href{https://arxiv.org/abs/1606.08415}{Gaussian Error Linear Units (GELUs)}
where the SiLU (Sigmoid Linear Unit) was originally coined, and see
\href{https://arxiv.org/abs/1702.03118}{Sigmoid-Weighted Linear Units for Neural Network Function Approximation in Reinforcement Learning}
and \href{https://arxiv.org/abs/1710.05941v1}{Swish: a Self-Gated Activation Function}
where the SiLU was experimented with later.
}
