% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/wrapers.R
\name{torch_kaiser_window}
\alias{torch_kaiser_window}
\title{Kaiser_window}
\usage{
torch_kaiser_window(
  window_length,
  periodic,
  beta,
  dtype = NULL,
  layout = NULL,
  device = NULL,
  requires_grad = NULL
)
}
\arguments{
\item{window_length}{(int) length of the window.}

\item{periodic}{(bool, optional) If TRUE, returns a periodic window suitable for use in spectral analysis.        If FALSE, returns a symmetric window suitable for use in filter design.}

\item{beta}{(float, optional) shape parameter for the window.}

\item{dtype}{(\code{torch.dtype}, optional) the desired data type of returned tensor.        Default: if \code{NULL}, uses a global default (see \code{torch_set_default_tensor_type}). If \code{dtype} is not given, infer the data type from the other input        arguments. If any of \code{start}, \code{end}, or \code{stop} are floating-point, the        \code{dtype} is inferred to be the default dtype, see        \code{~torch.get_default_dtype}. Otherwise, the \code{dtype} is inferred to        be \code{torch.int64}.}

\item{layout}{(\code{torch.layout}, optional) the desired layout of returned Tensor.        Default: \code{torch_strided}.}

\item{device}{(\code{torch.device}, optional) the desired device of returned tensor.        Default: if \code{NULL}, uses the current device for the default tensor type        (see \code{torch_set_default_tensor_type}). \code{device} will be the CPU        for CPU tensor types and the current CUDA device for CUDA tensor types.}

\item{requires_grad}{(bool, optional) If autograd should record operations on the        returned tensor. Default: \code{FALSE}.}
}
\description{
Kaiser_window
}
\note{
If \code{window_length} is one, then the returned window is a single element
tensor containing a one.
}
\section{kaiser_window(window_length, periodic=TRUE, beta=12.0, *, dtype=None, layout=torch.strided, device=None, requires_grad=FALSE) -> Tensor }{


Computes the Kaiser window with window length \code{window_length} and shape parameter \code{beta}.

Let I_0 be the zeroth order modified Bessel function of the first kind (see \code{\link[=torch_i0]{torch_i0()}}) and
\code{N = L - 1} if \code{periodic} is FALSE and \code{L} if \code{periodic} is TRUE,
where \code{L} is the \code{window_length}. This function computes:

\deqn{
    out_i = I_0 \left( \beta \sqrt{1 - \left( {\frac{i - N/2}{N/2}} \right) ^2 } \right) / I_0( \beta )
}

Calling \code{torch_kaiser_window(L, B, periodic=TRUE)} is equivalent to calling
\verb{torch_kaiser_window(L + 1, B, periodic=FALSE)[:-1])}.
The \code{periodic} argument is intended as a helpful shorthand
to produce a periodic window as input to functions like \code{\link[=torch_stft]{torch_stft()}}.
}

