% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session.R
\name{new_session}
\alias{new_session}
\title{Create a new tmux session}
\usage{
new_session(
  name = NULL,
  window_name = NULL,
  start_directory = NULL,
  width = 80,
  height = 24,
  detached = TRUE,
  shell_command = NULL
)
}
\arguments{
\item{name}{A string. Name of the session. If \code{NULL}, the
name determined by \code{tmux}, which is the next unused integer
(by default starting at 0). Default: \code{NULL}.}

\item{window_name}{A string. Name of initial window.}

\item{start_directory}{A string. Working directory this session is run in.}

\item{width}{An integer. Width of initial window. Default: 80.}

\item{height}{An integer. Height of initial window. Default: 24.}

\item{detached}{A logical. If \code{FALSE}, the \code{R} interpreter
waits for the session to be killed. Default: \code{TRUE}.}

\item{shell_command}{A string. Shell command to be invoked when creating the
session.}
}
\value{
A tmuxr_session.
}
\description{
Create a new tmux session with name \code{name}.
}
\note{
Prior to tmux version 2.6, the actual height is one line less than \code{height}.
}
\examples{
s <- new_session("foo", shell_command = "bash", height = 10)
list_sessions()
kill_session(s)

}
