% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view.R
\name{view}
\alias{view}
\title{Interactive Conversation Viewer}
\usage{
view(
  x,
  wh,
  text_col = "text",
  units.by = x$`_function.params`$units.by,
  conversation.by = x$`_function.params`$conversation.by,
  codes = x$rotation$codes,
  window_size = x$`_function.params`$window_size,
  more_cols = NULL,
  in_browser = FALSE,
  id_col = "QEUNIT"
)
}
\arguments{
\item{x}{A context model or data.frame containing conversation data.}

\item{wh}{Character or integer; unit(s) to view.}

\item{text_col}{Character; column name for text (default: "text").}

\item{units.by}{Character vector of unit grouping columns (default: from context model attributes).}

\item{conversation.by}{Character vector of conversation grouping columns (default: from context model attributes).}

\item{codes}{Character vector of code columns (default: from context model attributes).}

\item{window_size}{Integer; window size for co-occurrence (default: from context model attributes).}

\item{more_cols}{Character vector of additional columns to include in the viewer.}

\item{in_browser}{Logical; if TRUE, open in system browser, otherwise use RStudio viewer (default: FALSE).}

\item{id_col}{Character; column name for unit IDs (default: "QEUNIT").}
}
\value{
A list containing the viewer data and metadata (invisibly). The function is called for its side effect of launching the viewer.
}
\description{
Launch an interactive HTML viewer for conversations and codes for a specified unit or set of units. Useful for exploring and validating conversation windows and code assignments in the TMA workflow.
}
