% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tinytest.R
\name{expect_equal}
\alias{expect_equal}
\alias{expect_identical}
\alias{expect_equivalent}
\alias{expect_true}
\alias{expect_false}
\alias{expect_error}
\alias{expect_warning}
\title{Express expectations}
\usage{
expect_equal(current, target, tol = sqrt(.Machine$double.eps), ...)

expect_identical(current, target)

expect_equivalent(current, target, tol = sqrt(.Machine$double.eps), ...)

expect_true(current)

expect_false(current)

expect_error(current, pattern = ".*")

expect_warning(current, pattern = ".*")
}
\arguments{
\item{current}{\code{[R object or expression]} Outcome or expression under scrutiny.}

\item{target}{\code{[R object or expression]} Expected outcome}

\item{tol}{\code{[numeric]} Test equality to machine rounding. Passed
to \code{\link[base]{all.equal} (tolerance)}}

\item{...}{Passed to \code{all.equal}}

\item{pattern}{\code{[character]} A regular expression to match the message.}
}
\value{
A \code{\link{tinytest}} object. A tinytest object is a
\code{logical} with attributes holding information about the
test that was run
}
\description{
Express expectations
}
\details{
\code{expect_equivalent} calls \code{expect_equal} with the extra
arguments \code{check.attributes=FALSE} and \code{use.names=FALSE}
}
\note{
Each \code{expect_haha} function can also be called as \code{checkHaha}.
Although the interface is not entirely the same, it is expected that
this makes migration from the \code{RUnit} framework a little easier, for those
who wish to do so.
}
\examples{
expect_equal(1 + 1, 2)       # TRUE
expect_equal(1 - 1, 2)       # FALSE
expect_equivalent(2, c(x=2)) # TRUE
expect_equal(2, c(x=2))      # FALSE

}
\seealso{
Other test-functions: \code{\link{ignore}}
}
\concept{test-functions}
