% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar.R
\name{jdn}
\alias{jdn}
\alias{jdn2tind}
\title{Date and Date-Time Conversion to and from Julian Day Number (JDN)}
\usage{
jdn(x)

jdn2tind(x, tz = NULL)
}
\arguments{
\item{x}{an object of \code{tind} class or an R object coercible to it
for \code{jdn}, an integer or numeric vector for \code{jdn2tind}.}

\item{tz}{(optional) a character value determining the time zone (the default
\code{NULL} is interpreted as the system time zone).
See \code{\link{tzone}} documentation for information on time zones.}
}
\value{
An integer or numeric vector for \code{jdn}, an object of \code{tind} class
(type \code{"d"} or \code{"t"}) for \code{jdn2tind}.
}
\description{
\code{jdn} computes the JDNs for dates or date-time indices and
\code{jdn2tind} returns dates or date-time indices given JDNs.

For date arguments \code{jdn} returns the numbers of days
since November 24, 4714 BC in the proleptic Gregorian calendar as
an integer vector. For date-time arguments day fraction in UTC is computed
and the return value is a numeric vector.

For integer arguments \code{jdn2tind} return \code{tind} of type
\code{"d"} (date), for non-integer arguments --- \code{tind} of type
\code{"t"} (date-time). If \code{tz} argument is provided the return value
is always of type \code{"t"} (date-time).
}
\note{
For date-time indices JDN is computed based on day fraction
since noon UTC and not midnight, so 0.5 offset will be observable.
}
\examples{
# JDN of 2000-01-01 is 2451545
jdn("2000-01-01")
jdn2tind(2451545)
# JDN today, now?
jdn(today())
jdn(now())
# notice the .5 offset
jdn(today(tz = "UTC"))
format(jdn(as.date_time(today(tz = "UTC"), tz = "UTC")), digits = 8)

}
\seealso{
\code{\link{date2num}} for conversion between dates and their
integer representations found different software packages.
}
