% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted.tidyfit.models.R
\name{fitted.tidyfit.models}
\alias{fitted.tidyfit.models}
\title{Obtain fitted values from models in a \code{tidyfit.models} frame}
\usage{
\method{fitted}{tidyfit.models}(object, ...)
}
\arguments{
\item{object}{\code{model.frame} created using \code{\link{regress}}, \code{\link{classify}} or \code{\link{m}}}

\item{...}{currently not used}
}
\value{
A 'tibble'.
}
\description{
The function generates fitted values for all models in a \code{tidyfit.models} frame and outputs a tidy frame.
}
\details{
The function uses the 'model_object' column in a \code{tidyfit.model} frame to return fitted values for each model.
}
\examples{
data <- dplyr::group_by(tidyfit::Factor_Industry_Returns, Industry)
fit <- regress(data, Return ~ ., m("lm"), .mask = "Date")
fitted(fit)

}
\seealso{
\code{\link{coef.tidyfit.models}}, \code{\link{predict.tidyfit.models}} and \code{\link{residuals.tidyfit.models}}
}
\author{
Johann Pfitzinger
}
