% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.tvp.R
\name{.fit.tvp}
\alias{.fit.tvp}
\title{Bayesian Time-Varying Regression for \code{tidyfit}}
\usage{
\method{.fit}{tvp}(self, data = NULL)
}
\arguments{
\item{self}{a 'tidyFit' R6 class.}

\item{data}{a data frame, data frame extension (e.g. a tibble), or a lazy data frame (e.g. from dbplyr or dtplyr).}
}
\value{
A fitted 'tidyFit' class model.
}
\description{
Fits a Bayesian time-varying regression on a 'tidyFit' \code{R6} class. The function can be used with \code{\link{regress}}.
}
\details{
\strong{Hyperparameters:}

\emph{None. Cross validation not applicable.}

\strong{Important method arguments (passed to \code{\link{m}})}
\itemize{
\item \code{mod_type}
\item \code{niter} (number of MCMC iterations)
}

The function provides a wrapper for \code{shrinkTVP::shrinkTVP}. See \code{?shrinkTVP} for more details.

\strong{Implementation}

An argument \code{index_col} can be passed, which allows a custom index to be added to \code{coef(m("tvp"))} (e.g. a date index, see Examples).
}
\examples{
# Load data
data <- tidyfit::Factor_Industry_Returns
data <- dplyr::filter(data, Industry == "HiTec")
data <- dplyr::select(data, -Industry)

# Within 'regress' function (using low niter for illustration)
fit <- regress(data, Return ~ ., m("tvp", niter = 50, index_col = "Date"))
tidyr::unnest(coef(fit), model_info)

}
\references{
Peter Knaus, Angela Bitto-Nemling, Annalisa Cadonna and Sylvia Frühwirth-Schnatter (2021).
\emph{Shrinkage in the Time-Varying Parameter Model Framework Using the {R} Package {shrinkTVP}.
Journal of Statistical Software 100(13), 1--32}.
\doi{10.18637/jss.v100.i13}.\cr
}
\seealso{
\code{\link{.fit.bayes}}, \code{\link{.fit.mslm}} and \code{\link{m}} methods
}
\author{
Johann Pfitzinger
}
