ui = fluidPage(theme = add_theme(getShinyOption('theme')), 
               add_css(),

sidebarLayout(
  sidebarPanel(width = 3, 
  hr(),
  sliderInput("range.ll", 
              label = "Range",
              min = 0, 
              max = 50, 
              value = c(0,20)),
  hr(),
  sliderInput("mu.ll", 
              label = HTML("Mean (&mu;)"),
              min = 0.5, 
              max = 10, 
              step = 0.5, 
              value = 0.5, 
              animate = T),
  hr(),
  sliderInput("sig.ll", 
              label = HTML("Std Dev (&sigma;)"),
              min = 0.5, 
              max = 10, 
              step = 0.5, 
              value = 1, 
              animate = T)),

mainPanel(width = 9,
 tabsetPanel(type = 'pills',
  tabPanel('Distribution Function',  
           metricsgraphicsOutput(height = "550px","llogC")),
  tabPanel('Density',
           metricsgraphicsOutput(height = "550px", "llogP")),
  tabPanel('Survival',
           metricsgraphicsOutput(height = "550px", "llogR")),
  tabPanel('Hazard',
           metricsgraphicsOutput(height = "550px", "llogh")),
  tabPanel('Cumulative Hazard',
           metricsgraphicsOutput(height = "550px", "llogH")),
  tabPanel('Quantile',
           metricsgraphicsOutput(height = "550px", "llogQ"))))))
