% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_data_frame_with_weights.R
\name{as_data_frame_with_weights}
\alias{as_data_frame_with_weights}
\title{Convert Survey Design to Data Frame}
\usage{
as_data_frame_with_weights(
  design,
  full_wgt_name = "FULL_SAMPLE_WGT",
  rep_wgt_prefix = "REP_WGT_",
  vars_to_keep = NULL
)
}
\arguments{
\item{design}{A survey design object, created with either the \code{survey} or \code{srvyr} packages.}

\item{full_wgt_name}{The column name to use for the full-sample weights}

\item{rep_wgt_prefix}{For replicate design objects, a prefix to use for the column names
of the replicate weights. The column names will be created by appending
the replicate number after the prefix.}

\item{vars_to_keep}{By default, all variables in the data will be kept.
To select only a subset of the non-weight variables,
you can supply a character vector of variable names to keep.}
}
\value{
A data frame, with new columns containing the weights from the survey design object
}
\description{
Convert a survey design object to a data frame with weights stored as columns
}
\examples{

data("lou_vax_survey", package = 'svrep')

# Create a survey design object
survey_design <- svydesign(data = lou_vax_survey,
                           weights = ~ SAMPLING_WEIGHT,
                           ids = ~ 1)

rep_survey_design <- as.svrepdesign(survey_design,
                                    type = "boot",
                                    replicates = 10)

# Adjust the weights for nonresponse
nr_adjusted_design <- redistribute_weights(
  design = rep_survey_design,
  reduce_if = RESPONSE_STATUS == "Nonrespondent",
  increase_if = RESPONSE_STATUS == "Respondent",
  by = c("RACE_ETHNICITY", "EDUC_ATTAINMENT")
)

# Save the survey design object as a data frame
nr_adjusted_data <- as_data_frame_with_weights(
  nr_adjusted_design,
  full_wgt_name = "NR_ADJUSTED_WGT",
  rep_wgt_prefix = "NR_ADJUSTED_REP_WGT_"
)
head(nr_adjusted_data)

# Check the column names of the result
colnames(nr_adjusted_data)

}
