#' @importFrom tibble tibble
NULL

#' Partisan Politics in the Global Economy
#'
#' A data set on government spending in select rich countries as a function of
#' trade/GDP, financial openness, and the state-year-level engagement in trade
#' unions (among other things). The data offer a means to assess
#' Garrett's (1998) argument about left-wing governments' ability to stem the
#' tide of globalization's effect on decreased government spending. Data also
#' draw inspiration from Rodrik (1998) and Garrett (2001).
#'
#' @format A data frame with the following variables.
#' \describe{
#' \item{\code{country}}{a character vector for the country}
#' \item{\code{iso3c}}{a character vector for the three-character country ISO code}
#' \item{\code{year}}{the year}
#' \item{\code{govtspendgdp}}{total government spending over GDP}
#' \item{\code{tradegdp}}{the volume of trade over GDP}
#' \item{\code{kaopen}}{an index measuring a country's degree of capital account openness}
#' \item{\code{ka_open}}{an alternate index measuring a country's degree of capital account openness, normalized to be between 0 and 1}
#' \item{\code{v2catrauni}}{an estimate of a country's engagement in independent trade unions, generated by way of a Bayesian item response model}
#' \item{\code{v2catrauni_ord}}{an estimate of a country's engagement in independent trade unions, on ordinal scale. See details.}
#' \item{\code{ud}}{union density, as a percentage (i.e. union members/working employees)}
#' \item{\code{urbanperc}}{the percentage of the population living in urban areas)}
#' \item{\code{gdppc}}{GDP per capita, in constant 2015 USD}
#' \item{\code{tpop}}{total population size, in units of individual humans}
#' \item{\code{depratio}}{dependency ratio (see details)}
#' }
#'
#' @details The data are an unbalanced panel with assorted quirks during its
#' construction. Data missingness affecting Switzerland means it would only appear
#' in the panel starting in the mid-1990s. The Netherlands has some missing data
#' in the mid-1970s. Spain and Portugal appear at the start of the panel, though
#' the transition to democracy for both wouldn't start until 1974/1975. Union
#' density coverage is spotty for states like Greece and Portugal. The data also
#' have some obvious COVID weirdness for 2020. Use that to inform whatever case
#' or variable selection you would like to do. It may make sense to employ a
#' temporal domain of something like 1980 to 2005, or whatever. I don't know.
#' There's also the issue of what to do about the recession.
#'
#' The dependency ratio is defined as the population aged 0-14, or 65 and above,
#' divided over the "working-age" population of 15-64 (x 100).
#'
#' Briefly: the government spending/GDP data come from the International
#' Monetary Fund. The trade/GDP data come from the World Bank's API, as do the
#' population, GDP per capita, and urbanization data (see their details). The
#' more conventional union density data come from OECD/ICWSS. The financial
#' openness indicators come by way of the Chinn-Ito index. The engagement in
#' trade unions data are from the Varieties of Democracy project. The ordinal
#' measure of the trade union estimates communicate what percentage of the
#' population is active in independent trade unions. Values include 0)
#' virtually no one 1) a small share of the population (less than 5%), 2) A
#' moderate share of the population (about 5 to 15%). 3) A large share of
#' the population (about 16 % to 25%). 4) A very large share of the population
#' (about 26% or more).
#'
#' @references
#'
#' Coppedge, Michael, John Gerring, Carl Henrik Knutsen, Staffan I. Lindberg, Jan Teorell,
#' Nazifa Alizada, David Altman, Michael Bernhard, Agnes Cornell, M. Steven Fish, Lisa
#' Gastaldi, Haakon Gjerløw, Adam Glynn, Sandra Grahn, Allen Hicken, Garry Hindle, Nina
#' Ilchenko, Katrin Kinzelbach, Joshua Krusell, Kyle L. Marquardt, Kelly McMann, Valeriya
#' Mechkova, Juraj Medzihorsky, Pamela Paxton, Daniel Pemstein, Josefine Pernes, Oskar
#' Rydén, Johannes von Römer, Brigitte Seim, Rachel Sigman, Svend-Erik Skaaning, Jeffrey
#' Staton, Aksel Sundström, Eitan Tzelgov, Yi-ting Wang, Tore Wig, Steven Wilson and Daniel
#' Ziblatt. 2022. "V-Dem Country-Year/Country-Date Dataset v12" Varieties of Democracy
#' (V-Dem) Project. \doi{10.23696/vdemds22}
#'
#' Chinn, Menzie D. and Hiro Ito. 2006. "What Matters for Financial Development?
#' Capital Controls, Institutions, and Interactions." *Journal of Development
#' Economics* 81(1): 163--192.
#'
#' Garrett, Geoffrey. 1998. *Partisan Politics in the Global Economy* New York,
#' NY: Cambridge University Press.
#'
#' Garrett, Geoffrey. 2001. "Globalization and Government Spending around the
#' World." *Studies in Comparative International Development* 35(4): 3-29.
#'
#' Rodrik, Dani. 1998. "Why Do More Open Economies Have Bigger Government?"
#' *Journal of Political Economy* 106: 997-1032.
#'
"PPGE"
