% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifeRisk-base.R
\name{summary.lifeRisk}
\alias{summary.lifeRisk}
\title{Summarizing a LifeRisk}
\usage{
\method{summary}{lifeRisk}(object, ...)
}
\arguments{
\item{object}{S3 object of class lifeRisk.}

\item{...}{additional arguments.}
}
\value{
an S3 object, instance of class \code{c("summaryDefault", "table")}.
}
\description{
summary method for the S3 class lifeRisk.
}
\examples{
# Creating a new lifeRisk.

corr.mat <- diag(rep(1, 2))
colnames(corr.mat) <- c("invalidity", "longetivity")
rownames(corr.mat) <- colnames(corr.mat)

lifeRisk1 <- lifeRisk(corr.mat  = corr.mat,
                      quantile = c(0.995, 0.995))
# summarizing the lifeRisk.
summary(lifeRisk1)

}
\seealso{
\code{\link[base]{summary}}, \code{\link{lifeRisk}}.
}
