% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/life-base.R
\name{life}
\alias{life}
\title{Constructing a Life Delta-Normal Remainder Term
with Respect to lifeRisk}
\usage{
life(name, currency, sensitivity)
}
\arguments{
\item{name}{character value. The names of the life risk-factors (the life risk factors defined in \code{lifeRisk})
with respect to which sensitivities are computed (non-zero). This vector should not contain duplicated names.}

\item{currency}{character value representing currencies in which the
sensitivities are expressed. If the currency specified does not match the
base currency of the \code{marketRisk}, the initial
fx-rates will be used to convert to the base currency. Nevertheless, it is forced at construction of
a \code{portfolio} that the sensitivities should be provided in the \code{portfolio} base
currency.}

\item{sensitivity}{numeric value giving the sensitivities (understood as quantiles)
for the corresponding life risk-factors provided in \code{name}. Please consult the help page
of \code{lifeRisk} for more information on the meaning of these senstivities.
Sensitivities must be expressed in the corresponding currencies in \code{currency}.}
}
\value{
an S3 object, instance of the class life.
}
\description{
Constructor for the S3 class life.
  It allows to build for the sensitivities with respect to the life risk factors
  of the total positions not modeled by the other \code{marketItems}.
}
\note{
All parameters must be of equal length.
}
\examples{
# Creating a new health.
life1 <- life(name            = c("pandemy", "longetivity", "storno"),
              currency        = c("EUR", "CHF", "EUR"),
              sensitivity     = c(100, 150, 130))

}
\seealso{
\code{\link{summary.life}}, \code{\link{print.life}}.
}
