% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asc.from.raster.R
\name{asc.from.raster}
\alias{asc.from.raster}
\alias{raster.from.asc}
\alias{asc.from.sp}
\alias{sp.from.asc}
\alias{as.asc}
\title{Raster conversion functions for adehabitat, raster and sp packages}
\usage{
asc.from.raster(x)

raster.from.asc(x, projs = NA)

asc.from.sp(x)

sp.from.asc(x, projs = sp::CRS(as.character(NA)))

as.asc(
  x,
  xll = 1,
  yll = 1,
  cellsize = 1,
  type = c("numeric", "factor"),
  lev = levels(factor(x))
)
}
\arguments{
\item{x}{is an object of class 'asc', 'RasterLayer' or
'SpatialGridDataFrame'. For the function as.asc, a matrix}

\item{projs}{is a CRS projection string of the Proj4 package}

\item{xll}{the x coordinate of the center of the lower left pixel of the map}

\item{yll}{the y coordinate of the center of the lower left pixel of the map}

\item{cellsize}{the size of a pixel on the studied map}

\item{type}{a character string. Either "numeric" or "factor"}

\item{lev}{if type = "factor", either a vector giving the labels of
the factor levels, or the name of a file giving the  
correspondence table of the map see adehabitat as.asc 
helpfile details}
}
\value{
Returns an object of class requested.
}
\description{
Raster conversion functions for adehabitat, raster and sp packages
}
\note{
asc.from.raster and asc.from.sp extracts data from objects of
class 'RasterLayer' (raster package) and class 'SpatialGridDataFrame' 
(sp package) into an object of class 'asc' (adehabitat packages). 
raster.from.asc and sp.from.asc does the reverse.
as.asc creates an object of class 'asc' (SDMTools & adehabitat
packages) from a matrix of data. Code and helpfile associated with
as.asc were modified from adehabitat package.

These functions provide capabilities of using functions from many
packages including adehabitat, sp (plus e.g., maptools, rgdal) and raster.
}
\examples{
library(sp)
library(raster)

#create a simple object of class 'asc'
tasc = as.asc(matrix(rep(x=1:10, times=1000),nr=100))
  print(tasc)
  str(tasc)

#convert to RasterLayer
traster = raster.from.asc(tasc)
str(traster)

#convert to SpatialGridDataFrame
tgrid = sp.from.asc(tasc)
str(tgrid)

#create a basic object of class asc
( tasc = as.asc(matrix(rep(x=1:10, times=1000),nr=100)) )

}
\author{
Jeremy VanDerWal (code from depreciated/orphaned SDMTools package)
}
