% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{az.pdf}
\alias{az.pdf}
\title{Convert discrete azimuth measurements into probability distributions}
\usage{
az.pdf(
  pdf = "normal",
  az,
  unc,
  name,
  verbose = T,
  .cutoff = 1e-04,
  .res = 0.01
)
}
\arguments{
\item{pdf}{(Optional) String describing the probability distribution to be used. At the
moment only \emph{normal} and \emph{uniform} are supported. Default is \emph{normal}}

\item{az}{An array of azimuths}

\item{unc}{Azimuth uncertainties as either an array of the same length as \emph{az} or a single
value to be applied to all measurements}

\item{name}{(Optional) An array of names to identify each measurement}

\item{verbose}{(Optional) Boolean to control whether or not to display text. Default is TRUE.}

\item{.cutoff}{(Optional) Value of probability distribution(s) at which point it will be cutoff to save on memory. Default is 1e-4}

\item{.res}{(Optional) Azimuth resolution with which to output probability distribution(s). Default is 0.01 degrees.}
}
\description{
Convert discrete azimuth measurements into probability distributions
}
\examples{
test <- az.pdf(az=c(87,93,90,110), unc=3)
plot(test)
}
\references{
Silva, F (2020) A probabilistic framework and significance test for the analysis of structural orientations
 in skyscape archaeology \emph{Journal of Archaeological Science} 118, 105138. <doi:10.1016/j.jas.2020.105138>
}
