% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_config.R
\name{sits_config}
\alias{sits_config}
\title{Configure parameters for sits package}
\usage{
sits_config(config_user_file = NULL)
}
\arguments{
\item{config_user_file}{YAML user configuration file
(character vector of a file with "yml" extension)}
}
\value{
Called for side effects
}
\description{
These functions load and show sits configurations.

The `sits` package uses a configuration file
that contains information on parameters required by different functions.
This includes information about the image collections handled by `sits`.

\code{sits_config()} loads the default configuration file and
the user provided configuration file. The final configuration is
obtained by overriding the options by the values provided by the user.
}
\details{
Users can provide additional configuration files, by specifying the
location of their file in the environmental variable
\code{SITS_CONFIG_USER_FILE} or as parameter to this function.

To see the key entries and contents of the current configuration values,
use \code{link[sits]{sits_config_show()}}.
}
\examples{
yaml_user_file <- system.file("extdata/config_user_example.yml",
    package = "sits"
)
sits_config(config_user_file = yaml_user_file)
}
\author{
Rolf Simoes, \email{rolfsimoes@gmail.com}
}
