% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modal.R
\name{modal}
\alias{modal}
\alias{modalDialog}
\title{Create Semantic UI modal}
\usage{
modal(
  ...,
  id = "",
  class = "",
  header = NULL,
  content = NULL,
  footer = div(class = "ui button positive", "OK"),
  target = NULL,
  settings = NULL,
  modal_tags = NULL
)

modalDialog(..., title = NULL, footer = NULL)
}
\arguments{
\item{...}{Content elements to be added to the modal body.
To change attributes of the container please check the `content` argument.}

\item{id}{ID to be added to the modal div. Default "".}

\item{class}{Classes except "ui modal" to be added to the modal. Semantic UI classes can be used. Default "".}

\item{header}{Content to be displayed in the modal header.
If given in form of a list, HTML attributes for the container can also be changed. Default "".}

\item{content}{Content to be displayed in the modal body.
If given in form of a list, HTML attributes for the container can also be changed. Default NULL.}

\item{footer}{Content to be displayed in the modal footer. Usually for buttons.
If given in form of a list, HTML attributes for the container can also be changed.
Set NULL, to make empty.}

\item{target}{Javascript selector for the element that will open the modal. Default NULL.}

\item{settings}{list of vectors of Semantic UI settings to be added to the modal. Default NULL.}

\item{modal_tags}{character with title for \code{modalDialog} - equivalent to header}

\item{title}{title displayed in header in \code{modalDialog}}
}
\description{
This creates a modal using Semantic UI styles.
}
\examples{
## Create a simple server modal
if (interactive()) {
library(shiny)
library(shiny.semantic)

ui <- function() {
  shinyUI(
    semanticPage(
      actionButton("show", "Show modal dialog")
    )
  )
}

server = function(input, output) {
  observeEvent(input$show, {
    create_modal(modal(
      id = "simple-modal",
      header = h2("Important message"),
      "This is an important message!"
    ))
  })
}
shinyApp(ui, server)
}
## Create a simple UI modal

if (interactive()) {
library(shiny)
library(shiny.semantic)
ui <- function() {
  shinyUI(
    semanticPage(
      title = "Modal example - Static UI modal",
      div(id = "modal-open-button", class = "ui button", "Open Modal"),
      modal(
        div("Example content"),
        id = "example-modal",
        target = "modal-open-button"
      )
    )
  )
}

## Observe server side actions
library(shiny)
library(shiny.semantic)
ui <- function() {
  shinyUI(
    semanticPage(
      title = "Modal example - Server side actions",
      uiOutput("modalAction"),
      actionButton("show", "Show by calling show_modal")
    )
  )
}

server <- shinyServer(function(input, output) {
  observeEvent(input$show, {
    show_modal('action-example-modal')
  })
  observeEvent(input$hide, {
    hide_modal('action-example-modal')
  })

  output$modalAction <- renderUI({
    modal(
      actionButton("hide", "Hide by calling hide_modal"),
      id = "action-example-modal",
      header = "Modal example",
      footer = "",
      class = "tiny"
    )
  })
})
shinyApp(ui, server)
}
## Changing attributes of header and content.
if (interactive()) {
library(shiny)
library(shiny.semantic)

ui <- function() {
  shinyUI(
    semanticPage(
      actionButton("show", "Show modal dialog")
    )
  )
}

server = function(input, output) {
  observeEvent(input$show, {
    create_modal(modal(
      id = "simple-modal",
      title = "Important message",
      header = list("!!!", style = "background: lightcoral"),
      content = list(style = "background: lightblue",
                     `data-custom` = "value", "This is an important message!"),
      p("This is also part of the content!")
    ))
  })
}
shinyApp(ui, server)
}
if (interactive()) {
library(shiny)
library(shiny.semantic)
shinyApp(
  ui = semanticPage(
    actionButton("show", "Show modal dialog")
  ),
  server = function(input, output) {
    observeEvent(input$show, {
      showModal(modalDialog(
        title = "Important message",
        "This modal will close after 3 sec.", easyClose = FALSE
      ))
      Sys.sleep(3)
      removeModal()
    })
  }
)
}

}
