% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{create_ctree}
\alias{create_ctree}
\title{Make all conditional inference trees}
\usage{
create_ctree(
  given_ind,
  x_train,
  mincriterion,
  minsplit,
  minbucket,
  use_partykit = "on_error"
)
}
\arguments{
\item{given_ind}{Numeric value. Indicates which features are conditioned on.}

\item{x_train}{Numeric vector. Indicates the specific values of features for individual i.}

\item{mincriterion}{Numeric value or vector equal to 1 - alpha where alpha is the nominal level of the conditional
independence tests.
Can also be a vector equal to the length of the number of features indicating which mincriterion to use
when conditioning on various numbers of features.}

\item{minsplit}{Numeric value. Equal to the value that the sum of the left and right daughter nodes need to exceed.}

\item{minbucket}{Numeric value. Equal to the minimum sum of weights in a terminal node.}

\item{use_partykit}{String. In some semi-rare cases \code{partyk::ctree} runs into an error related to the LINPACK
used by R. To get around this problem, one may fall back to using the newer (but slower) \code{partykit::ctree}
function, which is a reimplementation of the same method. Setting this parameter to \code{"on_error"} (default)
falls back to  \code{partykit::ctree}, if \code{party::ctree} fails. Other options are \code{"never"}, which always
uses \code{party::ctree}, and \code{"always"}, which always uses \code{partykit::ctree}. A warning message is
created whenever \code{partykit::ctree} is used.}
}
\value{
List with conditional inference tree and the variables conditioned/not conditioned on.
}
\description{
Make all conditional inference trees
}
\examples{
if (requireNamespace("MASS", quietly = TRUE) & requireNamespace("party", quietly = TRUE)) {
  m <- 10
  n <- 40
  n_samples <- 50
  mu <- rep(1, m)
  cov_mat <- cov(matrix(rnorm(n * m), n, m))
  x_train <- data.table::data.table(MASS::mvrnorm(n, mu, cov_mat))
  given_ind <- c(4, 7)
  mincriterion <- 0.95
  minsplit <- 20
  minbucket <- 7
  sample <- TRUE
  create_ctree(
    given_ind = given_ind, x_train = x_train,
    mincriterion = mincriterion, minsplit = minsplit,
    minbucket = minbucket, use_partykit = "on_error"
  )
}
}
\author{
Annabelle Redelmeier, Martin Jullum
}
\keyword{internal}
