% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_edge_attribute.R
\name{set_edge_attribute}
\alias{set_edge_attribute}
\title{Set the Attributes of Selected Edges}
\usage{
set_edge_attribute(semPaths_plot, values = NULL, attribute_name = NULL)
}
\arguments{
\item{semPaths_plot}{A
\link[qgraph:qgraph]{qgraph::qgraph} object generated by
\link[semPlot:semPaths]{semPlot::semPaths}, or a similar
qgraph object modified by other
\link{semptools} functions.}

\item{values}{A named vector or a
list of named list. See the Details
section on how to set this argument.}

\item{attribute_name}{The name of
the attribute to be changed.}
}
\value{
A \link[qgraph:qgraph]{qgraph::qgraph} based on
the original one, with the selected
attributes of selected edges changed.
}
\description{
Set arbitrary
attributes of selected edges.
}
\details{
Modify a \link[qgraph:qgraph]{qgraph::qgraph}
object generated by
\link[semPlot:semPaths]{semPlot::semPaths} and change the
selected attributes of selected
edges.

This function is designed to be a
general one that changes the
attributes named by the user. The
user needs to make sure that the
attribute actually exists, and the
values are valid for the named
attribute.
\subsection{Setting the value of \code{values}}{

This argument can be set in two ways.

For a named vector, the name of an
element should be the path as
specified by \link[lavaan:model.syntax]{lavaan::model.syntax}
or as appeared in
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}.

For example, if the attributes to be
changed are the colors of selected
edges, to change the color of the
path regressing \code{y} on \code{x}, the name
should be \code{"y ~ x"}. To change the
color of the covariance between \code{x1}
and \code{x2}, the name should be \code{"x1 ~~ x2"}. Therefore, \code{c("y ~ x1" = "red", "x1 ~~ x2" = "blue")} changes the
colors of the path from \code{x1} to \code{y}
and the covariance between \code{x1} and
\code{x2} to \code{"red"} and \code{"blue"},
respectively.

The order of the two nodes \emph{may}
matter for covariances. Therefore, if
the attribute of a covariance is not
changed, try switching the order of
the two nodes.

For a list of named lists, each named
list should have three named values:
\code{from}, \code{to}, and \code{new_value}. The
attribute of the edge from \code{from} to
\code{to} will be set to \code{new_value}.

The second approach is no longer
recommended, though kept for backward
compatibility.
}
}
\examples{
mod_pa <-
  'x1 ~~ x2
   x3 ~  x1 + x2
   x4 ~  x1 + x3
  '
fit_pa <- lavaan::sem(mod_pa, pa_example)
lavaan::parameterEstimates(fit_pa)[, c("lhs", "op", "rhs", "est", "pvalue")]
m <- matrix(c("x1",   NA,   NA,
                NA, "x3", "x4",
              "x2",   NA,   NA), byrow = TRUE, 3, 3)
p_pa <- semPlot::semPaths(fit_pa, whatLabels="est",
            style = "ram",
            nCharNodes = 0, nCharEdges = 0,
            layout = m)

my_values_vector <- c("x2 ~~ x1" = "red",
                      "x4 ~ x1" = "blue")

p_pa2v <- set_edge_attribute(p_pa,
                             values = my_values_vector,
                             attribute_name = "color")
plot(p_pa2v)

my_values_list <- list(list(from = "x1", to = "x2", new_value = "red"),
                       list(from = "x1", to = "x4", new_value =  "blue"))

p_pa2l <- set_edge_attribute(p_pa,
                             values = my_values_list,
                             attribute_name = "color")

plot(p_pa2l)

}
