% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlogit.R
\name{mlogit}
\alias{mlogit}
\title{mlogit -- Convert multiple probabilities to log-scale numbers}
\usage{
mlogit(
  ...,
  maxiter = 10000,
  rtol = 1e-10,
  atol = 1e-12,
  ctol = 1e-12,
  returnRoot = FALSE
)
}
\arguments{
\item{...}{numeric probabilities to convert to log-scale numbers.
These probabilities must add to a number less than 1 and are used
in the mix() estimation algorithm.}

\item{maxiter}{maximal number of iterations allowed.
  }

\item{rtol}{relative error tolerance, either a scalar or a vector, one
    value for each element in the unknown x.
  }

\item{atol}{absolute error tolerance, either a scalar or a vector, one
    value for each element in x.
  }

\item{ctol}{a scalar. If between two iterations, the maximal change in
    the variable values is less than this amount, then it is assumed that
    the root is found.
  }

\item{returnRoot}{logical; If TRUE, return the root object,
otherwise return the root itself.}
}
\value{
A numeric vector of the log-scale numbers for use in
regressions where the sum of a set of probabilities must add to
be one.
}
\description{
These multiple probabilities need to add up to be less than 1.
}
\details{
Once converted to log-scale numbers, they can be used in the
in the \code{mexpit()} to get the probabilities back with the following equation

\deqn{p_i = \frac{e^{x_i}}{1+\sum_{j=1}^{N-1} e^{x_j}}}

This ensures one remaining probability will add to one, that is

\deqn{p_N = \frac{1}{1+\sum_{j=1}^{N-1} e^{x_j}}}

Unfortunately, the log-scale inverse cannot be solved analytically,
so it is solved with the \code{rootSolve::multiroot()} function.

You may adjust some of the root finding options when using this
function.

When running \code{nlmixr2} with mixture models (ie. \code{mix()} models),
the \code{mlogit()} function is called in the probabilities and the
log-based values are used in the optimization problem.  The
probabilities are determined by the \code{mexpit()} function.
}
\examples{

mlogit(0.1, 0.2, 0.3)

mlogit(0.1, 0.2, 0.3, returnRoot = TRUE)

}
\author{
Matthew L. Fidler
}
