% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlv.R
\name{load_mlv_player_boxscore}
\alias{load_mlv_player_boxscore}
\title{Load cleaned mlv player boxscore data from the volleydata repository.}
\usage{
load_mlv_player_boxscore(seasons = NULL)
}
\arguments{
\item{seasons}{An integer or vector of integers of seasons to fetch data for. Defaults to all available seasons.}
}
\value{
A data frame containing the player boxscore data for the specified seasons.\tabular{ll}{
   Column Name \tab Type \cr
   match_id \tab dbl \cr
   season \tab dbl \cr
   match_datetime \tab chr \cr
   set \tab dbl \cr
   set_start_time \tab chr \cr
   set_end_time \tab chr \cr
   set_duration \tab dbl \cr
   set_home_score \tab dbl \cr
   set_away_score \tab dbl \cr
   event_type \tab chr \cr
   event_time \tab chr \cr
   libero_enters \tab lgl \cr
   team_involved \tab chr \cr
   libero_jersey_number \tab dbl \cr
   libero_subsitute_jersey_number \tab dbl \cr
   rally_start_time \tab chr \cr
   rally_end_time \tab chr \cr
   point_team \tab chr \cr
   call_approved \tab lgl \cr
   player_in_jersey_number \tab dbl \cr
   player_out_jersey_number \tab dbl \cr
   challenge_reason \tab chr \cr
   challenge_method \tab chr \cr
   challenge_response \tab chr \cr
   challenge_result \tab chr \cr
   home_score_after_challenge \tab dbl \cr
   away_score_after_challenge \tab dbl \cr
}
}
\description{
Load cleaned mlv player boxscore data from the volleydata repository.
}
\examples{
try({load_mlv_player_boxscore(2024)})
}
