% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/welch_anova_test.R
\name{welch_anova_test}
\alias{welch_anova_test}
\title{Welch One-Way ANOVA Test}
\usage{
welch_anova_test(data, formula)
}
\arguments{
\item{data}{a data frame containing the variables in the formula.}

\item{formula}{a formula specifying the ANOVA model similar to aov. Can be of
the form y ~ group where y is a numeric variable giving the data values and
group is a factor with one or multiple levels giving the corresponding
groups. For example, formula = TP53 ~ cancer_group.}
}
\value{
return a data frame with the following columns: \itemize{ \item
  \code{.y.}: the y variable used in the test. \item \code{n}: sample count.
  \item \code{statistic}: the value of the test statistic. \item \code{p}:
  p-value. \item \code{method}: the statistical test used to compare groups.}
}
\description{
Tests for equal means in a one-way design (not assuming equal
  variance). A wrapper around the base function
  \code{\link[stats]{oneway.test}()}. This is is an alternative to the
  standard one-way ANOVA in the situation where the homogeneity of variance
  assumption is violated.
}
\examples{
# Load data
#:::::::::::::::::::::::::::::::::::::::
data("ToothGrowth")
df <- ToothGrowth
df$dose <- as.factor(df$dose)

# Welch one-way ANOVA test (not assuming equal variance)
#:::::::::::::::::::::::::::::::::::::::::
df \%>\% welch_anova_test(len ~ dose)

# Grouped data
#:::::::::::::::::::::::::::::::::::::::::
df \%>\%
  group_by(supp) \%>\%
  welch_anova_test(len ~ dose)
}
