% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{calcARI}
\alias{calcARI}
\title{Calculate adjusted Rand index (ARI) by comparing two cluster labeling variables}
\usage{
calcARI(
  object,
  trueCluster,
  useCluster = NULL,
  useDatasets = NULL,
  verbose = getOption("ligerVerbose", TRUE),
  classes.compare = trueCluster
)
}
\arguments{
\item{object}{A \linkS4class{liger} object, with the clustering result
present in cellMeta.}

\item{trueCluster}{Either the name of one variable in \code{cellMeta(object)}
or a factor object with annotation that matches with all cells being
considered.}

\item{useCluster}{The name of one variable in \code{cellMeta(object)}.
Default \code{NULL} uses default clusters.}

\item{useDatasets}{A character vector of the names, a numeric or logical
vector of the index of the datasets to be considered for the purity
calculation. Default \code{NULL} uses all datasets.}

\item{verbose}{Logical. Whether to show information of the progress. Default
\code{getOption("ligerVerbose")} or \code{TRUE} if users have not set.}

\item{classes.compare}{. \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}} Use
\code{trueCluster} instead.}
}
\value{
A numeric scalar, the ARI of the clustering result indicated by
\code{useCluster} compared to \code{trueCluster}.

A numeric scalar of the ARI value
}
\description{
This function aims at calculating the adjusted Rand index for the clustering
result obtained with LIGER and the external clustering (existing "true"
annotation). ARI ranges from 0 to 1, with a score of 0 indicating no
agreement between clusterings and 1 indicating perfect agreement.

The true clustering annotation must be specified as the base line. We suggest
setting it to the object cellMeta so that it can be easily used for many
other visualization and evaluation functions.

The ARI can be calculated for only specified datasets, since true annotation
might not be available for all datasets. Evaluation for only one or a few
datasets can be done by specifying \code{useDatasets}. If \code{useDatasets}
is specified, the argument checking for \code{trueCluster} and
\code{useCluster} will be enforced to match the cells in the specified
datasets.
}
\examples{
# Assume the true cluster in `pbmcPlot` is "leiden_cluster"
# generate fake new labeling
fake <- sample(1:7, ncol(pbmcPlot), replace = TRUE)
# Insert into cellMeta
pbmcPlot$new <- factor(fake)
calcARI(pbmcPlot, trueCluster = "leiden_cluster", useCluster = "new")

# Now assume we got existing base line annotation only for "stim" dataset
nStim <- ncol(dataset(pbmcPlot, "stim"))
stimTrueLabel <- factor(fake[1:nStim])
# Insert into cellMeta
cellMeta(pbmcPlot, "stim_true_label", useDatasets = "stim") <- stimTrueLabel
# Assume "leiden_cluster" is the clustering result we got and need to be
# evaluated
calcARI(pbmcPlot, trueCluster = "stim_true_label",
        useCluster = "leiden_cluster", useDatasets = "stim")

# Comparison of the same labeling should always yield 1.
calcARI(pbmcPlot, trueCluster = "leiden_cluster", useCluster = "leiden_cluster")
}
\references{
L. Hubert and P. Arabie (1985) Comparing Partitions, Journal of
the Classification, 2, pp. 193-218.
}
