% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block_ra.R
\name{block_ra}
\alias{block_ra}
\title{Block Random Assignment}
\usage{
block_ra(block_var, prob = NULL, prob_each = NULL, block_m = NULL,
  block_m_each = NULL, block_prob = NULL, block_prob_each = NULL,
  num_arms = NULL, condition_names = NULL, check_inputs = TRUE)
}
\arguments{
\item{block_var}{A vector of length N that indicates which block each unit belongs to. Can be a character, factor, or numeric vector. (required)}

\item{prob}{Use for a two-arm design in which either floor(N_block*prob) or ceiling(N_block*prob) units are assigned to treatment within each block. The probability of assignment to treatment is exactly prob because with probability 1-prob, floor(N_block*prob) units will be assigned to treatment and with probability prob, ceiling(N_block*prob) units will be assigned to treatment. prob must be a real number between 0 and 1 inclusive. (optional)}

\item{prob_each}{Use for a multi-arm design in which the values of prob_each determine the probabilties of assignment to each treatment condition. prob_each must be a numeric vector giving the probability of assignment to each condition. All entries must be nonnegative real numbers between 0 and 1 inclusive and the total must sum to 1. Because of integer issues, the exact number of units assigned to each condition may differ (slightly) from assignment to assignment, but the overall probability of assignment is exactly prob_each. (optional)}

\item{block_m}{Use for a two-arm design in which block_m describes the number of units to assign to treatment within each block. Note that in previous versions of randomizr, block_m behaved like block_m_each.}

\item{block_m_each}{Use for a multi-arm design in which the values of block_m_each determine the number of units assigned to each condition. block_m_each must be a matrix with the same number of rows as blocks and the same number of columns as treatment arms. Cell entries are the number of units to be assigned to each treatment arm within each block. The rows should respect the ordering of the blocks as determined by sort(unique(block_var)). The columns should be in the order of condition_names, if specified.}

\item{block_prob}{Use for a two-arm design in which block_prob describes the probability of assignment to treatment within each block. Differs from prob in that the probability of assignment can vary across blocks.}

\item{block_prob_each}{Use for a multi-arm design in which the values of block_prob_each determine the probabilties of assignment to each treatment condition. block_prob_each must be a matrix with the same number of rows as blocks and the same number of columns as treatment arms. Cell entries are the probabilites of assignment to treatment within each block. The rows should respect the ordering of the blocks as determined by sort(unique(block_var)). Use only if the probabilities of assignment should vary by block, otherwise use prob_each. Each row of block_prob_each must sum to 1.}

\item{num_arms}{The number of treatment arms. If unspecified, num_arms will be determined from the other arguments. (optional)}

\item{condition_names}{A character vector giving the names of the treatment groups. If unspecified, the treatment groups will be named 0 (for control) and 1 (for treatment) in a two-arm trial and T1, T2, T3, in a multi-arm trial. An execption is a two-group design in which num_arms is set to 2, in which case the condition names are T1 and T2, as in a multi-arm trial with two arms. (optional)}

\item{check_inputs}{logical. Defaults to TRUE.}
}
\value{
A vector of length N that indicates the treatment condition of each unit. Is numeric in a two-arm trial and a factor variable (ordered by condition_names) in a multi-arm trial.
}
\description{
block_ra implements a random assignment procedure in which units that are grouped into blocks defined by pre-treatment covariates are assiged using complete random assignment within block. For example, imagine that 50 of 100 men are assigned to treatment and 75 of 200 women are assigned to treatment.
}
\examples{

# Two-arm Designs

block_var <- rep(c("A", "B","C"), times = c(50, 100, 200))
Z <- block_ra(block_var = block_var)
table(block_var, Z)

Z <- block_ra(block_var = block_var, prob = .3)
table(block_var, Z)

Z <- block_ra(block_var = block_var, block_prob = c(.1, .2, .3))
table(block_var, Z)

Z <- block_ra(block_var = block_var, block_m = c(20, 30, 40))
table(block_var, Z)

block_m_each <- rbind(c(25, 25),
                 c(50, 50),
                 c(100, 100))

Z <- block_ra(block_var = block_var, block_m_each = block_m_each)
table(block_var, Z)

block_m_each <- rbind(c(10, 40),
                 c(30, 70),
                 c(50, 150))

Z <- block_ra(block_var = block_var, block_m_each = block_m_each,
              condition_names = c("control", "treatment"))
table(block_var, Z)

# Multi-arm Designs
Z <- block_ra(block_var = block_var, num_arms = 3)
table(block_var, Z)

block_m_each <- rbind(c(10, 20, 20),
                 c(30, 50, 20),
                 c(50, 75, 75))
Z <- block_ra(block_var = block_var, block_m_each = block_m_each)
table(block_var, Z)

Z <- block_ra(block_var = block_var, block_m_each = block_m_each,
              condition_names = c("control", "placebo", "treatment"))
table(block_var, Z)

Z <- block_ra(block_var = block_var, prob_each = c(.1, .1, .8))
table(block_var, Z)



}
