% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3JSgrid.R
\name{grid3js}
\alias{grid3js}
\title{Add axis grids to an data3js object}
\usage{
grid3js(
  data3js,
  sides = c("x", "y", "z"),
  axes = c("x", "y", "z"),
  at = NULL,
  dynamic = TRUE,
  col = "grey95",
  lwd = 1,
  geometry = FALSE,
  ...
)
}
\arguments{
\item{data3js}{The data3js object}

\item{sides}{The axis sides to show the box, any combination of "x", "y" or "z"}

\item{axes}{Axes for which to draw the grid lines}

\item{at}{Where to draw grid lines along the axis}

\item{dynamic}{Should edges of the box closest to the viewer hide themselves automatically}

\item{col}{Grid line color}

\item{lwd}{Grid line width}

\item{geometry}{Should the lines be rendered as a physical geometry in the scene (see \code{lines3js()})}

\item{...}{Other arguments to pass to \code{material3js()}}
}
\value{
Returns an updated data3js object
}
\description{
This is used for example by \code{plot3js()} to add axis grids to a plot
these show along the faces of the plotting box, indicating axis ticks.
}
\examples{
# Setup blank base plot
p <- plot3js(draw_grid = FALSE, xlab = "X", ylab = "Y", zlab = "Z")

# Add a box
p <- box3js(p)

# Add grid lines but only for the z axis
p <- grid3js(
  p, col = "red",
  axes = "z"
)

r3js(p)

# Add grid lines but only for the z axis and
# only at either end of the x axis
p <- grid3js(
  p, col = "blue",
  axes = "z",
  sides = "x"
)

r3js(p)

}
\seealso{
Other plot components: 
\code{\link{arrows3js}()},
\code{\link{axis3js}()},
\code{\link{box3js}()},
\code{\link{legend3js}()},
\code{\link{light3js}()},
\code{\link{lines3js}()},
\code{\link{mtext3js}()},
\code{\link{points3js}()},
\code{\link{segments3js}()},
\code{\link{shape3js}()},
\code{\link{sphere3js}()},
\code{\link{surface3js}()},
\code{\link{text3js}()},
\code{\link{triangle3js}()}
}
\concept{plot components}
