% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diary_functions.R
\name{ngrp}
\alias{ngrp}
\title{Number of Groups in Data}
\usage{
ngrp(data, grp.nm)
}
\arguments{
\item{data}{data.frame of data.}

\item{grp.nm}{character vector of colnames from \code{data} specifying the
grouping variables.}
}
\value{
integer vector of length 1 specifying the number of groups.
}
\description{
\code{ngrp} computes the number of groups in data given one or more grouping
variables. This is simply a combination of \code{unique.data.frame} +
\code{nrow}.
}
\examples{

# one grouping variable
Orthodont2 <- as.data.frame(nlme::Orthodont)
ngrp(Orthodont2, grp.nm = "Subject")
length(unique(Orthodont2$"Subject"))

# two grouping variable
co2 <- as.data.frame(CO2)
ngrp(co2, grp.nm = c("Plant"))
grp_nm <- c("Type","Treatment")
ngrp(co2, grp.nm = grp_nm)
unique.data.frame(co2[grp_nm])

#TODO: how does it handle factor levels with no cases?

}
\seealso{
\code{\link{nrow_ml}}
   \code{\link{ncases_ml}}
   \code{\link{nrow_by}}
   \code{\link{ncases_by}}
}
