% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qgis-state.R
\name{qgis_using_json_input}
\alias{qgis_using_json_input}
\alias{qgis_using_json_output}
\title{Report if JSON objects are used for input to and output from 'qgis_process'}
\usage{
qgis_using_json_input()

qgis_using_json_output(query = FALSE, quiet = TRUE)
}
\arguments{
\item{query}{Use \code{TRUE} to refresh the cached value.}

\item{quiet}{Use \code{FALSE} to display more information,
possibly useful for debugging.}
}
\value{
A logical of length 1.
}
\description{
Returns a logical that reveals whether the JSON input and output methods are
used, respectively.
}
\details{
Since QGIS 3.24 the JSON input method of 'qgis_process' is used by default
when calling the command.
It allows for more complex input argument types in certain algorithms that
require a more complex input argument, e.g. a list of lists (see
\code{\link[=qgis_list_input]{qgis_list_input()}}).

Likewise, JSON output is the default output format requested from
'qgis_process'.

The settings can be overruled with the options
\code{qgisprocess.use_json_input} or \code{qgisprocess.use_json_output}, and with the
environment variables \code{R_QGISPROCESS_USE_JSON_INPUT} or
\code{R_QGISPROCESS_USE_JSON_OUTPUT.}
Since the JSON output method is cached by the package,
\code{qgis_using_json_output(query = TRUE)} is needed for these settings to take
effect if the package was loaded already.
}
\examples{
\dontshow{if (has_qgis()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
qgis_using_json_input()
\dontshow{\}) # examplesIf}
}
\seealso{
Other topics about programming or debugging utilities: 
\code{\link{qgis_result_status}()},
\code{\link{qgis_run}()},
\code{\link{qgis_tmp_file}()},
\code{\link{qgis_unconfigure}()}

Other topics about reporting the QGIS state: 
\code{\link{has_qgis}()},
\code{\link{qgis_algorithms}()},
\code{\link{qgis_path}()}
}
\concept{functions to manage and explore QGIS and qgisprocess}
\concept{topics about programming or debugging utilities}
\concept{topics about reporting the QGIS state}
