% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qgis-configure.R
\name{qgis_configure}
\alias{qgis_configure}
\title{Configure qgisprocess}
\usage{
qgis_configure(quiet = FALSE, use_cached_data = FALSE)
}
\arguments{
\item{quiet}{Use \code{FALSE} to display more information,
possibly useful for debugging.}

\item{use_cached_data}{Use the cached algorithm list and \code{path} found when
configuring qgisprocess during the last session. This saves some time
loading the package.}
}
\value{
The result of \code{\link[processx:run]{processx::run()}}.
}
\description{
Run \code{qgis_configure()} to bring the package configuration in line with
QGIS and to save this configuration to a persistent cache.
See the \emph{Details} section for more information about setting the path of
the 'qgis_process' command line tool.
}
\details{
The qgisprocess package is a wrapper around the 'qgis_process' command line
tool distributed with QGIS (>=3.14). Several functions use heuristics to
detect the location of the 'qgis_process' executable.

When loading the package, the configuration is automatically read from the
cache with \code{qgis_configure(use_cached_data = TRUE, quiet = TRUE)} in order
to save time.
Run \code{qgis_configure(use_cached_data = TRUE)} manually to get more details.

Use \code{qgis_algorithms()}, \code{qgis_providers()}, \code{qgis_plugins()},
\code{qgis_using_json_output()}, \code{qgis_path()} and \code{qgis_version()} to inspect cache
contents.

If the configuration
fails or you have more than one QGIS installation, you can set
\code{options(qgisprocess.path = "path/to/qgis_process")} or the
\code{R_QGISPROCESS_PATH} environment variable (useful on CI). On Linux the
'qgis_process' executable is generally available on the user's PATH,
on MacOS the executable is within the QGIS*.app/Contents/MacOS/bin folder,
and on Windows the executable is named qgis_process-qgis.bat or
qgis_process-qgis-dev.bat and is located in Program Files/QGIS*/bin or
OSGeo4W(64)/bin.
}
\examples{
\donttest{
# not running in R CMD check to save time
qgis_configure(use_cached_data = TRUE)
}

\dontrun{
# package reconfiguration
# (not run in example() as it rewrites the package cache file)
qgis_configure()
}

}
\seealso{
\code{\link[=qgis_unconfigure]{qgis_unconfigure()}}

\code{\link[=qgis_path]{qgis_path()}}, \code{\link[=qgis_version]{qgis_version()}}

Other topics about configuring QGIS and qgisprocess: 
\code{\link{qgis_enable_plugins}()},
\code{\link{qgis_run}()}
}
\concept{functions to manage and explore QGIS and qgisprocess}
\concept{topics about configuring QGIS and qgisprocess}
