% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qgis-algorithms.R, R/qgis-plugins.R
\name{qgis_algorithms}
\alias{qgis_algorithms}
\alias{qgis_providers}
\alias{qgis_plugins}
\title{List algorithms, processing providers or plugins}
\usage{
qgis_algorithms(query = FALSE, quiet = TRUE)

qgis_providers(query = FALSE, quiet = TRUE)

qgis_plugins(which = "all", query = FALSE, quiet = TRUE, ...)
}
\arguments{
\item{query}{Use \code{TRUE} to refresh the cached value.}

\item{quiet}{Use \code{FALSE} to display more information,
possibly useful for debugging.}

\item{which}{String defining which plugins to select, based on their
status in QGIS (enabled or disabled).
Must be one of: \code{"all"}, \code{"enabled"}, \code{"disabled"}.}

\item{...}{Only used by other functions calling this function.}
}
\value{
A tibble of algorithms, processing providers or plugins, with metadata.
}
\description{
Functions that return metadata about the installed and enabled algorithms or
processing providers, or about the installed plugins that implement
processing providers.
See the \href{https://docs.qgis.org/latest/en/docs/user_manual/processing_algs/qgis/index.html}{QGIS docs}
for a detailed description of the algorithms provided
'out of the box' on QGIS.
}
\examples{
\dontshow{if (has_qgis()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
qgis_algorithms()
qgis_providers()
qgis_plugins(quiet = FALSE)
qgis_plugins(which = "disabled")
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=qgis_enable_plugins]{qgis_enable_plugins()}}, \code{\link[=qgis_disable_plugins]{qgis_disable_plugins()}}

Other topics about information on algorithms & processing providers: 
\code{\link{qgis_search_algorithms}()},
\code{\link{qgis_show_help}()}

Other topics about reporting the QGIS state: 
\code{\link{has_qgis}()},
\code{\link{qgis_path}()},
\code{\link{qgis_using_json_input}()}
}
\concept{functions to manage and explore QGIS and qgisprocess}
\concept{topics about information on algorithms & processing providers}
\concept{topics about reporting the QGIS state}
