% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recodes.R
\name{recodes}
\alias{recodes}
\title{Recode one or more variables}
\usage{
recodes(data, vars, from, to)
}
\arguments{
\item{data}{a data frame.}

\item{vars}{character vector of variable names.}

\item{from}{a vector of values or conditions (see Details).}

\item{to}{a vector of replacement values.}
}
\value{
a data frame
}
\description{
\code{recodes} recodes the values of one or more variables in
a data frame
}
\details{
\itemize{
\item For each variable in the \code{vars} parameter, values
are checked against the list of values in the \code{from} vector.
If a value matches, it is replaced with the corresponding
entry in the \code{to} vector.
\item Once a given observation's value matches a \code{from} value, it is
recoded. That particular observation will not be recoded again by
that \code{recodes()} statement (i.e., no chaining).
\item One or more values in the \code{from} vector can be an expression,
using the dollar sign ($) to represent the variable being recoded.
If the expression
evaluates to \code{TRUE}, the corresponding \code{to} value is
returned.
\item If the number of values in the \code{to} vector is less than
the \code{from} vector, the values are recycled. This lets you
convert several values to a single outcome value (e.g., \code{NA}).
\item If the \code{to} values are numeric, the resulting recoded variable
will be numeric. If the variable being recoded is a factor and the
\code{to} values are character values, the resulting variable will
remain a factor. If the variable being recoded is a character variable
and the \code{to} values are character values, the resulting
variable will remain a character variable.
}
}
\note{
See the vignette for detailed examples.
}
\examples{
df <- data.frame(x = c(1, 5, 7, 3, 0),
                 y = c(9, 0, 5, 9, 2),
                 z = c(1, 1, 2, 2, 1)
                 )
df <- recodes(df, 
              vars = c("x", "y"), 
              from = 0, to = NA)
df <- recodes(df, 
              vars = "z", 
              from = c(1, 2), to = c("pass", "fail"))

}
