% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_plot.R
\name{cor_plot}
\alias{cor_plot}
\title{Correlation matrix plot}
\usage{
cor_plot(
  data,
  method = c("pearson", "kendall", "spearman"),
  sort = FALSE,
  axis_text_size = 12,
  number_text_size = 3,
  legend = FALSE
)
}
\arguments{
\item{data}{data frame}

\item{method}{a character string indicating which correlation
coefficient is to be computed. One of "pearson" (default), "kendall",
or "spearman".}

\item{sort}{logical. If \code{TRUE}, reorder variables to place variables
with similar correlation patterns together.}

\item{axis_text_size}{size for axis labels (default=12).}

\item{number_text_size}{size for correlation coefficient labels (default=3).}

\item{legend}{logical, if TRUE the legend is displayed.
(default=FALSE)}
}
\value{
a ggplot graph
}
\description{
Create a correlation matrix for all quantitative variables in a data frame.
}
\details{
The \code{cor_plot} function will only select quantitative variables from
a data frame. Categorical variables are ignored.
The correlation matrix is presented as a lower triangle matrix.
Missing values are deleted in listwise fashion.
}
\note{
This function is a wrapper for the \code{\link[ggcorrplot:ggcorrplot]{ggcorrplot}} function.
}
\examples{
cor_plot(cars74)
cor_plot(cars74, sort=TRUE)
}
