% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1_logistic.R
\name{D1_logistic}
\alias{D1_logistic}
\title{D1 method for Predictor selection called by psfmi_lr}
\usage{
D1_logistic(data, impvar, nimp, fm, names.var)
}
\arguments{
\item{data}{Data frame or data matrix with stacked multiple imputed datasets.
The original dataset that contains missing values must be excluded from the dataset.}

\item{impvar}{A character vector. Name of the variable that distinguishes the imputed datasets.}

\item{nimp}{A numerical scalar. Number of imputed datasets. Default is 5.}

\item{fm}{regression formula from glm object}

\item{names.var}{list of predictors included in pooled regression model}
}
\description{
\code{D1_logistic} D1 pooling method
}
\examples{
 D1_logistic(data=lbpmilr, nimp=5, impvar="Impnr", 
 fm=Chronic ~ Gender + Smoking + Function + JobControl,
 names.var=list("Gender", "Smoking", "Function", "JobControl"))

}
