% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisq.gof.R
\name{chisq.gof}
\alias{chisq.gof}
\title{Power calculation for chi-square goodness-of-fit test}
\usage{
chisq.gof(
  p0vec = NULL,
  p1vec = NULL,
  N = NULL,
  alpha = 0.05,
  power = NULL,
  v = FALSE
)
}
\arguments{
\item{p0vec}{Vector of probabilities for the specified population distribution. Must sum to 1.}

\item{p1vec}{Vector of expected probabilities for the sample. Must sum to 1.}

\item{N}{The total number of observations.}

\item{alpha}{The significance level (type 1 error rate); defaults to 0.05.}

\item{power}{The specified level of power.}

\item{v}{Either TRUE for verbose output or FALSE (default) to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
Performs sample size and power calculations for chi-square goodness-of-fit test,
which is used to test whether a sample of data arises from a population with a specific
discrete distribution.
This function can solve for power, total sample size or alpha.
}
\examples{
chisq.gof(p0vec = c(0.5, 0.3, 0.2), p1vec = c(0.7, 0.15, 0.15), N = 50)
}
