% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupcorplot.r
\name{groupcorplot}
\alias{groupcorplot}
\title{Plots the correlation coefficient between measures across groups/units}
\usage{
groupcorplot(x, y, group, data, stat)
}
\arguments{
\item{x}{A vector.}

\item{y}{A vector.}

\item{group}{A vector that contians group identifiers.}

\item{data}{A data frame.}

\item{stat}{The type of correlation coefficient to be calculated. One of "pearson", "kendall", or "spearman".}
}
\value{
A figure that plots the correlation coefficient between measures across groups/units.
}
\description{
Returns a figure that plots the correlation coefficient between measures within groups/units. This can be used to visually explore the relationsip between two factors within cases.
}
\examples{
\dontrun{
a <- runif(1000, min = 0, max = 1)
b <- a + rnorm(1000, mean = 0, sd =1)
c <- rep(c(1:10), times = 100)
data <- data.frame(a, b, c)
groupcorplot("a", "b", "c", data, "pearson")
print(dat)
}
}
\author{
Charles Crabtree \email{ccrabtr@umich.edu}
}

