% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R
\name{pipe_replace_step}
\alias{pipe_replace_step}
\title{Replace pipeline step}
\usage{
pipe_replace_step(
  pip,
  step,
  fun,
  params = list(),
  description = "",
  group = step,
  keepOut = FALSE
)
}
\arguments{
\item{pip}{\code{Pipeline} object}

\item{step}{\code{string} the name of the step. Each step name must
be unique.}

\item{fun}{\code{function} or name of the function to be applied at
the step. Both existing and anonymous/lambda functions can be used.
All function parameters must have default values. If a parameter
is missing a default value in the function signature, alternatively,
it can be set via the \code{params} argument (see Examples section with
\code{\link[=mean]{mean()}} function).}

\item{params}{\code{list} list of parameters to set or overwrite
parameters of the passed function.}

\item{description}{\code{string} optional description of the step}

\item{group}{\code{string} output collected after pipeline execution
(see function \code{\link[=pipe_collect_out]{pipe_collect_out()}}) is grouped by the defined group
names. By default, this is the name of the step, which comes in
handy when the pipeline is copy-appended multiple times to keep
the results of the same function/step grouped at one place.}

\item{keepOut}{\code{logical} if \code{FALSE} (default) the output of the
step is not collected when calling \code{\link[=pipe_collect_out]{pipe_collect_out()}} after the
pipeline run. This option is used to only keep the results that matter
and skip intermediate results that are not needed. See also
function \code{\link[=pipe_collect_out]{pipe_collect_out()}} for more details.}
}
\value{
returns the \code{Pipeline} object invisibly
}
\description{
Replaces an existing pipeline step.
}
\examples{
p <- pipe_new("pipe", data = 1)
pipe_add(p, "add1", \(x = ~data, y = 1) x + y)
pipe_add(p, "add2", \(x = ~data, y = 2) x + y)
pipe_add(p, "mult", \(x = 1, y = 2) x * y, keepOut = TRUE)
pipe_run(p) |> pipe_collect_out()
pipe_replace_step(p, "mult", \(x = ~add1, y = ~add2) x * y, keepOut = TRUE)
pipe_run(p) |> pipe_collect_out()
try(pipe_replace_step(p, "foo", \(x = 1) x))   # step 'foo' does not exist
}
\seealso{
\code{\link[=pipe_add]{pipe_add()}}
}
