% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workdocs_operations.R
\name{workdocs_update_user}
\alias{workdocs_update_user}
\title{Updates the specified attributes of the specified user, and grants or
revokes administrative privileges to the Amazon WorkDocs site}
\usage{
workdocs_update_user(AuthenticationToken, UserId, GivenName, Surname,
  Type, StorageRule, TimeZoneId, Locale, GrantPoweruserPrivileges)
}
\arguments{
\item{AuthenticationToken}{Amazon WorkDocs authentication token. Not required when using AWS
administrator credentials to access the API.}

\item{UserId}{[required] The ID of the user.}

\item{GivenName}{The given name of the user.}

\item{Surname}{The surname of the user.}

\item{Type}{The type of the user.}

\item{StorageRule}{The amount of storage for the user.}

\item{TimeZoneId}{The time zone ID of the user.}

\item{Locale}{The locale of the user.}

\item{GrantPoweruserPrivileges}{Boolean value to determine whether the user is granted Poweruser
privileges.}
}
\value{
A list with the following syntax:\preformatted{list(
  User = list(
    Id = "string",
    Username = "string",
    EmailAddress = "string",
    GivenName = "string",
    Surname = "string",
    OrganizationId = "string",
    RootFolderId = "string",
    RecycleBinFolderId = "string",
    Status = "ACTIVE"|"INACTIVE"|"PENDING",
    Type = "USER"|"ADMIN"|"POWERUSER"|"MINIMALUSER"|"WORKSPACESUSER",
    CreatedTimestamp = as.POSIXct(
      "2015-01-01"
    ),
    ModifiedTimestamp = as.POSIXct(
      "2015-01-01"
    ),
    TimeZoneId = "string",
    Locale = "en"|"fr"|"ko"|"de"|"es"|"ja"|"ru"|"zh_CN"|"zh_TW"|"pt_BR"|"default",
    Storage = list(
      StorageUtilizedInBytes = 123,
      StorageRule = list(
        StorageAllocatedInBytes = 123,
        StorageType = "UNLIMITED"|"QUOTA"
      )
    )
  )
)
}
}
\description{
Updates the specified attributes of the specified user, and grants or
revokes administrative privileges to the Amazon WorkDocs site.
}
\section{Request syntax}{
\preformatted{svc$update_user(
  AuthenticationToken = "string",
  UserId = "string",
  GivenName = "string",
  Surname = "string",
  Type = "USER"|"ADMIN"|"POWERUSER"|"MINIMALUSER"|"WORKSPACESUSER",
  StorageRule = list(
    StorageAllocatedInBytes = 123,
    StorageType = "UNLIMITED"|"QUOTA"
  ),
  TimeZoneId = "string",
  Locale = "en"|"fr"|"ko"|"de"|"es"|"ja"|"ru"|"zh_CN"|"zh_TW"|"pt_BR"|"default",
  GrantPoweruserPrivileges = "TRUE"|"FALSE"
)
}
}

\keyword{internal}
